/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.factories;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaClassElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassStubFactory
implements LightStubElementFactory<PsiClassStubImpl<PsiClass>, PsiClass> {
    @NotNull
    public PsiClassStubImpl<PsiClass> createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        LighterASTNode parent;
        IElementType type;
        if (tree == null) {
            JavaClassStubFactory.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JavaClassStubFactory.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            JavaClassStubFactory.$$$reportNull$$$0(2);
        }
        boolean isDeprecatedByComment = false;
        boolean isInterface = false;
        boolean isEnum = false;
        boolean isRecord = false;
        boolean isValueClass = false;
        boolean isEnumConst = false;
        boolean isAnonymous = false;
        boolean isAnnotation = false;
        boolean isInQualifiedNew = false;
        boolean classKindFound = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String qualifiedName = null;
        String name = null;
        String baseRef = null;
        if (node.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
            isAnonymous = true;
            classKindFound = true;
        } else if (node.getTokenType() == JavaElementType.ENUM_CONSTANT_INITIALIZER) {
            isEnumConst = true;
            isAnonymous = true;
            classKindFound = true;
            baseRef = ((PsiClassStub)parentStub.getParentStub()).getName();
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                isValueClass = RecordUtil.hasValueModifier(tree, child);
                continue;
            }
            if (type == JavaTokenType.AT) {
                isAnnotation = true;
                continue;
            }
            if (type == JavaTokenType.INTERFACE_KEYWORD && !classKindFound) {
                isInterface = true;
                classKindFound = true;
                continue;
            }
            if (type == JavaTokenType.ENUM_KEYWORD && !classKindFound) {
                isEnum = true;
                classKindFound = true;
                continue;
            }
            if (type == JavaTokenType.RECORD_KEYWORD && !classKindFound) {
                isRecord = true;
                classKindFound = true;
                continue;
            }
            if (type == JavaTokenType.CLASS_KEYWORD) {
                classKindFound = true;
                continue;
            }
            if (!isAnonymous && type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!isAnonymous || isEnumConst || type != JavaElementType.JAVA_CODE_REFERENCE) continue;
            baseRef = LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)child, null);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName = !pkg.isEmpty() ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                String string = qualifiedName = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        if (isAnonymous && (parent = tree.getParent(node)) != null && parent.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            isInQualifiedNew = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)parent, (IElementType)JavaTokenType.DOT) != null;
        }
        boolean isImplicit = node.getTokenType() == JavaElementType.IMPLICIT_CLASS;
        short flags = PsiClassStubImpl.packFlags(isDeprecatedByComment, isInterface, isEnum, isEnumConst, isAnonymous, isAnnotation, isInQualifiedNew, hasDeprecatedAnnotation, false, false, hasDocComment, isRecord, isImplicit, isValueClass);
        type = JavaClassStubFactory.typeForClass(isAnonymous, isEnumConst, isImplicit);
        return new PsiClassStubImpl<PsiClass>((IJavaElementType)type, parentStub, qualifiedName, name, baseRef, flags);
    }

    public PsiClass createPsi(@NotNull PsiClassStubImpl<PsiClass> stub) {
        if (stub == null) {
            JavaClassStubFactory.$$$reportNull$$$0(3);
        }
        return JavaStubElementType.getFileStub(stub).getPsiFactory().createClass(stub);
    }

    @NotNull
    public PsiClassStubImpl<PsiClass> createStub(@NotNull PsiClass psi, @Nullable StubElement parentStub) {
        if (psi == null) {
            JavaClassStubFactory.$$$reportNull$$$0(4);
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @NotNull
    public static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst, boolean implicitClass) {
        JavaClassElementType javaClassElementType = enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (implicitClass ? JavaStubElementTypes.IMPLICIT_CLASS : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS));
        if (javaClassElementType == null) {
            JavaClassStubFactory.$$$reportNull$$$0(5);
        }
        return javaClassElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/factories/JavaClassStubFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/factories/JavaClassStubFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "typeForClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

