/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.surroundWith;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.surroundWith.GroovyManyStatementsSurrounder;

public class SurrounderByClosure
extends GroovyManyStatementsSurrounder {
    private static final Key<GroovyResolveResult> REF_RESOLVE_RESULT_KEY = Key.create((String)"REF_RESOLVE_RESULT");

    public String getTemplateDescription() {
        return GroovyBundle.message("surround.with.closure", new Object[0]);
    }

    @Override
    protected GroovyPsiElement doSurroundElements(PsiElement[] elements, PsiElement context) throws IncorrectOperationException {
        for (PsiElement element : elements) {
            if (!(element instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)element).accept(new MyMemoizingVisitor());
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(elements[0].getProject());
        GrMethodCallExpression call = (GrMethodCallExpression)factory.createExpressionFromText("{ -> \n}.call()", context);
        GrClosableBlock closure = (GrClosableBlock)((GrReferenceExpression)call.getInvokedExpression()).getQualifierExpression();
        SurrounderByClosure.addStatements(closure, elements);
        return call;
    }

    @Override
    protected TextRange getSurroundSelectionRange(GroovyPsiElement element) {
        element.accept(new MyRestoringVisitor());
        assert (element instanceof GrMethodCallExpression);
        int offset = element.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    private static class MyMemoizingVisitor
    extends GroovyRecursiveElementVisitor {
        private MyMemoizingVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression ref2) {
            if (ref2 == null) {
                MyMemoizingVisitor.$$$reportNull$$$0(0);
            }
            if (ref2.getQualifierExpression() == null) {
                GroovyResolveResult resolveResult = ref2.advancedResolve();
                ref2.putCopyableUserData(REF_RESOLVE_RESULT_KEY, resolveResult);
            }
            super.visitReferenceExpression(ref2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/surroundWith/SurrounderByClosure$MyMemoizingVisitor", "visitReferenceExpression"));
        }
    }

    private static class MyRestoringVisitor
    extends GroovyRecursiveElementVisitor {
        private MyRestoringVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression ref2) {
            GroovyResolveResult oldResult;
            if (ref2 == null) {
                MyRestoringVisitor.$$$reportNull$$$0(0);
            }
            if ((oldResult = (GroovyResolveResult)ref2.getCopyableUserData(REF_RESOLVE_RESULT_KEY)) != null) {
                assert (ref2.getQualifierExpression() == null);
                GroovyResolveResult newResult = ref2.advancedResolve();
                PsiElement oldElement = oldResult.getElement();
                PsiElement newElement = newResult.getElement();
                if (!ref2.getManager().areElementsEquivalent(oldElement, newElement) || oldResult.getCurrentFileResolveContext() != newResult.getCurrentFileResolveContext()) {
                    GrReferenceExpression qualifier = GroovyPsiElementFactory.getInstance(ref2.getProject()).createReferenceExpressionFromText("owner");
                    ref2.setQualifier(qualifier);
                }
            }
            super.visitReferenceExpression(ref2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/lang/surroundWith/SurrounderByClosure$MyRestoringVisitor", "visitReferenceExpression"));
        }
    }
}

