/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitLocalBranch;
import git4idea.actions.GitLogSingleCommitAction;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lgit4idea/actions/GitPushUpToCommitAction;", "Lgit4idea/actions/GitLogSingleCommitAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/Hash;", "getSourceReference", "", "hash", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitPushUpToCommitAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitPushUpToCommitAction.kt\ngit4idea/actions/GitPushUpToCommitAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class GitPushUpToCommitAction
extends GitLogSingleCommitAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Object object;
        GitLocalBranch currentBranch;
        GitRepository repository2;
        CommitId commit;
        VcsLogData logData;
        VcsLogCommitSelection selection;
        Project project;
        block12: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project2 == null) {
                return;
            }
            project = project2;
            VcsLogCommitSelection vcsLogCommitSelection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
            if (vcsLogCommitSelection == null) {
                return;
            }
            selection = vcsLogCommitSelection;
            Object object2 = e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
            VcsLogData vcsLogData = object2 instanceof VcsLogData ? (VcsLogData)object2 : null;
            if (vcsLogData == null) {
                return;
            }
            logData = vcsLogData;
            commit = (CommitId)CollectionsKt.first((List)selection.getCommits());
            GitRepository gitRepository = this.getRepositoryForRoot(project, commit.getRoot());
            Intrinsics.checkNotNull((Object)gitRepository);
            repository2 = gitRepository;
            currentBranch = repository2.getCurrentBranch();
            VirtualFile virtualFile = repository2.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, hash);
            if (branches.contains("HEAD") && currentBranch != null) {
                object = currentBranch;
            } else {
                for (Object it : (Iterable)branches) {
                    boolean bl = false;
                    it = repository2.getBranches().findLocalBranch((String)it);
                    if (it == null) continue;
                    object = it;
                    break block12;
                }
                object = null;
            }
        }
        GitLocalBranch branch = object;
        GitPushSource referenceToPush = null;
        if (Registry.Companion.is("git.push.upto.commit.with.head.reference") && branch != null && Intrinsics.areEqual((Object)((Object)branch), (Object)((Object)currentBranch))) {
            GitCommitEditingActionBase.MultipleCommitEditingData multipleCommitEditingData = new GitCommitEditingActionBase.MultipleCommitEditingData(repository2, selection, logData);
            String string = GitBundle.message((String)"push.up.to.commit.allowed.progress.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String description = GitCommitEditingActionBase.Companion.checkHeadLinearHistory(multipleCommitEditingData, string);
            if (description != null) {
                Messages.showErrorDialog((Project)project, (String)description, (String)GitBundle.message((String)"push.upto.here.failed.dialog.title", (Object[])new Object[0]));
                return;
            }
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            String sourceReference = this.getSourceReference(repository2, hash);
            String string2 = sourceReference;
            if (string2 == null) {
                String string3 = commit.getHash().asString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            }
            GitPushSource gitPushSource = GitPushSource.createRef(branch, string2);
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createRef(...)");
            referenceToPush = gitPushSource;
        } else if (branch != null) {
            GitPushSource gitPushSource = GitPushSource.createRef(branch, commit.getHash().asString());
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createRef(...)");
            referenceToPush = gitPushSource;
        } else {
            GitPushSource gitPushSource = GitPushSource.createDetached(commit.getHash().asString());
            Intrinsics.checkNotNullExpressionValue((Object)gitPushSource, (String)"createDetached(...)");
            referenceToPush = gitPushSource;
        }
        new VcsPushDialog(repository2.getProject(), (Collection)CollectionsKt.listOf((Object)repository2), CollectionsKt.listOf((Object)repository2), (Repository)repository2, (PushSource)referenceToPush).show();
    }

    protected void actionPerformed(@NotNull GitRepository repository2, @NotNull Hash commit) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
    }

    private final String getSourceReference(GitRepository repository2, Hash hash) {
        Ref.ObjectRef reference = new Ref.ObjectRef();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GitPushUpToCommitAction.getSourceReference$lambda$2(repository2, hash, reference), GitBundle.message((String)"push.up.to.commit.getting.reference.progress.title", (Object[])new Object[0]), true, repository2.getProject());
        return (String)reference.element;
    }

    private static final void getSourceReference$lambda$2(GitRepository $repository, Hash $hash, Ref.ObjectRef $reference) {
        block0: {
            Integer count;
            String string = GitHistoryUtils.getNumberOfCommitsBetween($repository, $hash.asString(), "HEAD");
            Integer n = count = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            $reference.element = count > 0 ? "HEAD^" + count : "HEAD";
        }
    }
}

