/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge.svg12;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import org.jetbrains.relocated.apache.batik.anim.dom.SVGOMDocument;
import org.jetbrains.relocated.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.BridgeException;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.PaintBridge;
import org.jetbrains.relocated.apache.batik.bridge.PaintServer;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngine;
import org.jetbrains.relocated.apache.batik.css.engine.CSSStylableElement;
import org.jetbrains.relocated.apache.batik.css.engine.StyleMap;
import org.jetbrains.relocated.apache.batik.css.engine.value.Value;
import org.jetbrains.relocated.apache.batik.dom.util.XLinkSupport;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;

public class SVGSolidColorElementBridge
extends AnimatableGenericSVGBridge
implements PaintBridge {
    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    @Override
    public String getLocalName() {
        return "solidColor";
    }

    @Override
    public Paint createPaint(BridgeContext ctx2, Element paintElement, Element paintedElement, GraphicsNode paintedNode, float opacity) {
        opacity = SVGSolidColorElementBridge.extractOpacity(paintElement, opacity, ctx2);
        return SVGSolidColorElementBridge.extractColor(paintElement, opacity, ctx2);
    }

    protected static float extractOpacity(Element paintElement, float opacity, BridgeContext ctx2) {
        HashMap<ParsedURL, ParsedURL> refs = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine eng = CSSUtilities.getCSSEngine(paintElement);
        int pidx = eng.getPropertyIndex("solid-opacity");
        while (true) {
            Value opacityVal = CSSUtilities.getComputedStyle(paintElement, pidx);
            StyleMap sm = ((CSSStylableElement)paintElement).getComputedStyleMap(null);
            if (!sm.isNullCascaded(pidx)) {
                float attr = PaintServer.convertOpacity(opacityVal);
                return opacity * attr;
            }
            String uri = XLinkSupport.getXLinkHref(paintElement);
            if (uri.length() == 0) {
                return opacity;
            }
            SVGOMDocument doc = (SVGOMDocument)paintElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (refs.containsKey(purl)) {
                throw new BridgeException(ctx2, paintElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.put(purl, purl);
            paintElement = ctx2.getReferencedElement(paintElement, uri);
        }
    }

    protected static Color extractColor(Element paintElement, float opacity, BridgeContext ctx2) {
        HashMap<ParsedURL, ParsedURL> refs = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine eng = CSSUtilities.getCSSEngine(paintElement);
        int pidx = eng.getPropertyIndex("solid-color");
        while (true) {
            Value colorDef = CSSUtilities.getComputedStyle(paintElement, pidx);
            StyleMap sm = ((CSSStylableElement)paintElement).getComputedStyleMap(null);
            if (!sm.isNullCascaded(pidx)) {
                if (colorDef.getCssValueType() == 1) {
                    return PaintServer.convertColor(colorDef, opacity);
                }
                return PaintServer.convertRGBICCColor(paintElement, colorDef.item(0), colorDef.item(1), opacity, ctx2);
            }
            String uri = XLinkSupport.getXLinkHref(paintElement);
            if (uri.length() == 0) {
                return new Color(0.0f, 0.0f, 0.0f, opacity);
            }
            SVGOMDocument doc = (SVGOMDocument)paintElement.getOwnerDocument();
            ParsedURL purl = new ParsedURL(doc.getURL(), uri);
            if (refs.containsKey(purl)) {
                throw new BridgeException(ctx2, paintElement, "xlink.href.circularDependencies", new Object[]{uri});
            }
            refs.put(purl, purl);
            paintElement = ctx2.getReferencedElement(paintElement, uri);
        }
    }
}

