/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.DefaultMutationGuard;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.EventSubscriptionVerifier;
import org.gradle.api.internal.provider.ChangingValue;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;

public abstract class AbstractIterationOrderRetainingElementSource<T>
implements ElementSource<T> {
    private final List<Element<T>> inserted = new ArrayList<Element<T>>();
    private final MutationGuard lazyGuard = new DefaultMutationGuard();
    private Action<T> pendingAddedAction;
    private EventSubscriptionVerifier<T> subscriptionVerifier = type -> false;
    protected int modCount;

    List<Element<T>> getInserted() {
        return this.inserted;
    }

    @Override
    public boolean isEmpty() {
        for (Element<T> element : this.inserted) {
            if (element.size() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.inserted.isEmpty();
    }

    @Override
    public int size() {
        int count = 0;
        for (Element<T> element : this.inserted) {
            count += element.size();
        }
        return count;
    }

    @Override
    public int estimatedSize() {
        return this.size();
    }

    @Override
    public boolean contains(Object element) {
        return Iterators.contains(this.iterator(), (Object)element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        for (Object e : elements) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Iterator iterator = this.iteratorNoFlush();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (!value.equals(o)) continue;
            iterator.remove();
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.inserted.clear();
    }

    @Override
    public void realizeExternal(ProviderInternal<? extends T> provider) {
    }

    @Override
    public void realizePending() {
        for (Element<T> element : this.inserted) {
            if (element.isRealized()) continue;
            ++this.modCount;
            element.realize();
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        for (Element<T> element : this.inserted) {
            if (element.isRealized() || element.getType() != null && !type.isAssignableFrom(element.getType())) continue;
            ++this.modCount;
            element.realize();
        }
    }

    protected void clearCachedElement(Element<T> element) {
        ++this.modCount;
        element.clearCache();
    }

    Element<T> cachingElement(ProviderInternal<? extends T> provider) {
        Element element = new Element(provider.getType(), new Collectors.ElementFromProvider(provider), this::doAddRealized);
        if (provider instanceof ChangingValue) {
            ((ChangingValue)Cast.uncheckedNonnullCast(provider)).onValueChange(previousValue -> this.clearCachedElement(element));
        }
        return element;
    }

    Element<T> cachingElement(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        Element element = new Element(provider.getElementType(), new Collectors.ElementsFromCollectionProvider(provider), this::doAddRealized);
        if (provider instanceof ChangingValue) {
            ((ChangingValue)Cast.uncheckedNonnullCast(provider)).onValueChange(previousValues -> this.clearCachedElement(element));
        }
        return element;
    }

    private void doAddRealized(T value) {
        if (this.addRealized(value) && this.pendingAddedAction != null) {
            this.pendingAddedAction.execute(value);
        }
    }

    abstract boolean addRealized(T var1);

    @Override
    public boolean removePending(ProviderInternal<? extends T> provider) {
        return this.removeByProvider(provider);
    }

    private boolean removeByProvider(ProviderInternal<?> provider) {
        Iterator<Element<T>> iterator = this.inserted.iterator();
        while (iterator.hasNext()) {
            Element<T> next = iterator.next();
            if (next.isRealized() || !next.isProvidedBy((Provider)provider)) continue;
            ++this.modCount;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removePendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        return this.removeByProvider((ProviderInternal<?>)provider);
    }

    @Override
    public void onPendingAdded(Action<T> action) {
        this.pendingAddedAction = action;
    }

    @Override
    public void setSubscriptionVerifier(EventSubscriptionVerifier<T> subscriptionVerifier) {
        this.subscriptionVerifier = subscriptionVerifier;
    }

    protected boolean addPendingElement(Element<T> element) {
        boolean added = this.inserted.add(element);
        if (this.subscriptionVerifier.isSubscribed(element.getType())) {
            element.realize();
            element.clearCache();
        }
        return added;
    }

    @Override
    public MutationGuard getLazyBehaviorGuard() {
        return this.lazyGuard;
    }

    protected static class Element<T>
    extends Collectors.TypedCollector<T> {
        private List<T> cache = null;
        private List<T> removedValues = null;
        private IntSet duplicates = IntSets.emptySet();
        private boolean realized;
        private final Action<T> realizeAction;

        Element(@Nullable Class<? extends T> type, Collector<T> delegate, Action<T> realizeAction) {
            super(type, delegate);
            this.realizeAction = realizeAction;
        }

        Element(T value) {
            super(null, (Collector)new Collectors.SingleElement(value));
            this.realizeAction = null;
            this.realize();
        }

        public boolean isRealized() {
            return this.realized;
        }

        public void realize() {
            if (this.cache == null) {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.delegate.size());
                super.collectInto((ImmutableCollection.Builder)builder);
                this.cache = new ArrayList<T>(builder.build());
                if (this.removedValues != null) {
                    this.cache.removeAll(this.removedValues);
                }
                this.realized = true;
                if (this.realizeAction != null) {
                    LinkedHashSet<T> realizedValues = new LinkedHashSet<T>();
                    for (T value : this.cache) {
                        if (realizedValues.contains(value)) continue;
                        this.realizeAction.execute(value);
                        realizedValues.add(value);
                    }
                }
            }
        }

        public void collectInto(ImmutableCollection.Builder<T> builder) {
            if (!this.realized) {
                this.realize();
            }
            builder.addAll(this.cache);
        }

        List<T> getValues() {
            if (!this.realized) {
                this.realize();
            }
            return this.cache;
        }

        public boolean remove(T value) {
            if (this.removedValues == null) {
                this.removedValues = new ArrayList<T>();
            }
            this.removedValues.add(value);
            if (this.cache != null) {
                return this.cache.remove(value);
            }
            return true;
        }

        boolean isDuplicate(int index) {
            return this.duplicates.contains(index);
        }

        void setDuplicate(int index) {
            if (this.duplicates == IntSets.EMPTY_SET) {
                this.duplicates = new IntOpenHashSet(1);
            }
            this.duplicates.add(index);
        }

        void clearCache() {
            this.cache = null;
            this.realized = false;
            this.duplicates = IntSets.emptySet();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Element that = (Element)((Object)o);
            return Objects.equal((Object)this.delegate, (Object)that.delegate) && Objects.equal(this.cache, that.cache);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate, this.cache});
        }
    }

    protected static class ValuePointer<T> {
        private final Element<T> element;
        private final Integer index;

        public ValuePointer(Element<T> element, Integer index) {
            this.element = element;
            this.index = index;
        }

        public Element<T> getElement() {
            return this.element;
        }

        public Integer getIndex() {
            return this.index;
        }
    }

    protected class RealizedElementCollectionIterator
    implements Iterator<T> {
        final List<Element<T>> backingList;
        final Spec<ValuePointer<?>> acceptanceSpec;
        int nextIndex = -1;
        int nextSubIndex = -1;
        int previousIndex = -1;
        int previousSubIndex = -1;
        T next;
        int expectedModCount;

        RealizedElementCollectionIterator(List<Element<T>> backingList, Spec<ValuePointer<?>> acceptanceSpec) {
            this.expectedModCount = AbstractIterationOrderRetainingElementSource.this.modCount;
            this.backingList = backingList;
            this.acceptanceSpec = acceptanceSpec;
            this.updateNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        private void updateNext() {
            int i;
            if (this.nextIndex == -1) {
                this.nextIndex = 0;
            }
            for (i = this.nextIndex; i < this.backingList.size(); ++i) {
                Element candidate = this.backingList.get(i);
                if (!candidate.isRealized()) continue;
                List collected = candidate.getValues();
                for (int j = this.nextSubIndex + 1; j < collected.size(); ++j) {
                    Object value = collected.get(j);
                    if (!this.acceptanceSpec.isSatisfiedBy(new ValuePointer(candidate, j))) continue;
                    this.nextIndex = i;
                    this.nextSubIndex = j;
                    this.next = value;
                    return;
                }
                this.nextSubIndex = -1;
            }
            this.nextIndex = i;
            this.next = null;
        }

        @Override
        public T next() {
            this.checkForComodification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object thisNext = this.next;
            this.previousIndex = this.nextIndex;
            this.previousSubIndex = this.nextSubIndex;
            this.updateNext();
            return thisNext;
        }

        @Override
        public void remove() {
            if (this.previousIndex > -1) {
                this.checkForComodification();
                Element element = this.backingList.get(this.previousIndex);
                List collected = element.getValues();
                if (collected.size() > 1) {
                    element.remove(collected.get(this.previousSubIndex));
                    --this.nextSubIndex;
                } else {
                    this.backingList.remove(this.previousIndex);
                    --this.nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this.previousIndex = -1;
            this.previousSubIndex = -1;
        }

        final void checkForComodification() {
            if (AbstractIterationOrderRetainingElementSource.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

