/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CriticSettingsPanel
implements DataEntryPanel {
    protected final CriticAndSettings settings;
    protected final JPanel panel;
    protected final JComboBox severityCombo;
    protected final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private final SPListener severitySettingListener = new AbstractSPListener(){

        public void propertyChanged(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("severity")) {
                Object oldSeverity = CriticSettingsPanel.this.severityCombo.getSelectedItem();
                CriticSettingsPanel.this.severityCombo.setSelectedItem(evt.getNewValue());
                for (PropertyChangeListener l : CriticSettingsPanel.this.listeners) {
                    l.propertyChange(new PropertyChangeEvent(CriticSettingsPanel.this, "severity", oldSeverity, evt.getNewValue()));
                }
            }
        }
    };

    public CriticSettingsPanel(CriticAndSettings settings) {
        this.settings = settings;
        this.panel = new JPanel();
        this.severityCombo = new JComboBox<CriticAndSettings.Severity>(CriticAndSettings.Severity.values());
        if (settings.getPlatformType().equals(CriticAndSettings.StarterPlatformTypes.CONFIGURATION.getName())) {
            this.severityCombo.removeItem((Object)CriticAndSettings.Severity.WARNING);
        }
        this.severityCombo.setSelectedItem((Object)settings.getSeverity());
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 5dlu, pref"), this.panel);
        builder.append((Component)new JLabel(settings.getName()));
        builder.append((Component)this.severityCombo);
        settings.addSPListener(this.severitySettingListener);
    }

    public boolean applyChanges() {
        this.settings.setSeverity((CriticAndSettings.Severity)((Object)this.severityCombo.getSelectedItem()));
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return !((CriticAndSettings.Severity)((Object)this.severityCombo.getSelectedItem())).equals((Object)this.settings.getSeverity());
    }

    public void cleanup() {
        this.settings.removeSPListener(this.severitySettingListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public CriticAndSettings getSettings() {
        return this.settings;
    }
}

