/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.MainFooterPanel;
import org.parosproxy.paros.view.MainMenuBar;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.MainToolbarPanel;
import org.zaproxy.zap.view.ZapToggleButton;
import org.zaproxy.zap.view.widgets.PopupButton;

public class MainFrame
extends AbstractFrame {
    private static final Logger LOGGER = LogManager.getLogger(MainFrame.class);
    private static final String TABS_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.tabs");
    private static final String TAB_SIDE_BY_SIDE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.tabSideBySide");
    private static final String ABOVE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.above");
    private static final String DISABLED_ABOVE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.above.disabled");
    private static final String SIDE_BY_SIDE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.sideBySide");
    private static final String DISABLED_SIDE_BY_SIDE_VIEW_TOOL_TIP = Constant.messages.getString("view.toolbar.messagePanelsPosition.sideBySide.disabled");
    private static final long serialVersionUID = -1430550461546083192L;
    private final OptionsParam options;
    private JPanel paneContent = null;
    private final WorkbenchPanel paneStandard;
    private MainMenuBar mainMenuBar = null;
    private JPanel paneDisplay = null;
    private MainToolbarPanel mainToolbarPanel = null;
    private MainFooterPanel mainFooterPanel = null;
    private ZapToggleButton showTabIconNamesButton;
    private JButton showAllTabsButton;
    private JButton hideAllTabsButton;
    private WorkbenchPanel.Layout workbenchLayout;
    private JToggleButton expandSelectLayoutButton;
    private JToggleButton expandStatusLayoutButton;
    private JToggleButton fullLayoutButton;
    private WorkbenchPanel.ResponsePanelPosition responsePanelPosition;
    private ZapToggleButton tabsResponsePanelPositionButton;
    private ZapToggleButton tabSideBySideResponsePanelPositionButton;
    private ZapToggleButton aboveResponsePanelPositionButton;
    private ZapToggleButton panelsResponsePanelPositionButton;
    private PopupButton lookAndFeelButton;

    @Deprecated
    public MainFrame(int displayOption) {
        this(Model.getSingleton().getOptionsParam(), View.getSingleton().getRequestPanel(), View.getSingleton().getResponsePanel());
        this.changeDisplayOption(displayOption);
    }

    public MainFrame(OptionsParam options, AbstractPanel requestPanel, AbstractPanel responsePanel) {
        if (options == null) {
            throw new IllegalArgumentException("Parameter options must not be null");
        }
        if (requestPanel == null) {
            throw new IllegalArgumentException("Parameter requestPanel must not be null");
        }
        if (responsePanel == null) {
            throw new IllegalArgumentException("Parameter responsePanel must not be null");
        }
        this.options = options;
        this.paneStandard = new WorkbenchPanel(options.getViewParam(), requestPanel, responsePanel);
        this.paneStandard.setLayout(new CardLayout());
        this.paneStandard.setName("paneStandard");
        this.initialize();
        this.applyViewOptions();
    }

    private void initialize() {
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getPaneContent());
        this.setPreferredSize(new Dimension(1000, 800));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.getMainMenuBar().getMenuFileControl().exit();
            }
        });
        this.setVisible(false);
    }

    private JPanel getPaneContent() {
        if (this.paneContent == null) {
            this.paneContent = new JPanel();
            this.paneContent.setLayout(new BoxLayout(this.getPaneContent(), 1));
            this.paneContent.setEnabled(true);
            this.paneContent.add((Component)this.getMainToolbarPanel(), null);
            this.paneContent.add((Component)this.getPaneDisplay(), null);
            this.paneContent.add((Component)this.getMainFooterPanel(), null);
        }
        return this.paneContent;
    }

    public WorkbenchPanel getWorkbench() {
        return this.paneStandard;
    }

    public MainMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new MainMenuBar();
        }
        return this.mainMenuBar;
    }

    public JPanel getPaneDisplay() {
        if (this.paneDisplay == null) {
            this.paneDisplay = new JPanel();
            this.paneDisplay.setLayout(new CardLayout());
            this.paneDisplay.setName("paneDisplay");
            this.paneDisplay.add((Component)this.getWorkbench(), this.getWorkbench().getName());
        }
        return this.paneDisplay;
    }

    public MainToolbarPanel getMainToolbarPanel() {
        if (this.mainToolbarPanel == null) {
            this.mainToolbarPanel = new MainToolbarPanel();
            this.mainToolbarPanel.addToolBarComponent(this.getLookAndFeelButton());
            this.mainToolbarPanel.addSeparator();
            this.mainToolbarPanel.addButton(this.getShowAllTabsButton());
            this.mainToolbarPanel.addButton(this.getHideAllTabsButton());
            this.mainToolbarPanel.addButton(this.getShowTabIconNamesButton());
            this.mainToolbarPanel.addSeparator();
            ButtonGroup layoutsButtonGroup = new ButtonGroup();
            this.mainToolbarPanel.addButton(this.getExpandSelectLayoutButton());
            layoutsButtonGroup.add(this.getExpandSelectLayoutButton());
            this.mainToolbarPanel.addButton(this.getExpandStatusLayoutButton());
            layoutsButtonGroup.add(this.getExpandStatusLayoutButton());
            this.mainToolbarPanel.addButton(this.getFullLayoutButton());
            layoutsButtonGroup.add(this.getFullLayoutButton());
            this.mainToolbarPanel.addSeparator();
            ButtonGroup responsePanelPositionsButtonGroup = new ButtonGroup();
            this.mainToolbarPanel.addButton(this.getTabsResponsePanelPositionButton());
            responsePanelPositionsButtonGroup.add(this.getTabsResponsePanelPositionButton());
            this.mainToolbarPanel.addButton(this.getTabSideBySideResponsePanelPositionButton());
            responsePanelPositionsButtonGroup.add(this.getTabSideBySideResponsePanelPositionButton());
            this.mainToolbarPanel.addButton(this.getPanelsResponsePanelPositionButton());
            responsePanelPositionsButtonGroup.add(this.getPanelsResponsePanelPositionButton());
            this.mainToolbarPanel.addButton(this.getAboveResponsePanelPositionButton());
            responsePanelPositionsButtonGroup.add(this.getAboveResponsePanelPositionButton());
            this.mainToolbarPanel.addSeparator();
        }
        return this.mainToolbarPanel;
    }

    private JButton getShowAllTabsButton() {
        if (this.showAllTabsButton == null) {
            this.showAllTabsButton = new JButton();
            this.showAllTabsButton.setIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/fugue/ui-tab-show.png")));
            this.showAllTabsButton.setToolTipText(Constant.messages.getString("menu.view.tabs.show"));
            DisplayUtils.scaleIcon(this.showAllTabsButton);
            this.showAllTabsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View.getSingleton().showAllTabs();
                }
            });
        }
        return this.showAllTabsButton;
    }

    private JButton getHideAllTabsButton() {
        if (this.hideAllTabsButton == null) {
            this.hideAllTabsButton = new JButton();
            this.hideAllTabsButton.setIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/fugue/ui-tab-hide.png")));
            this.hideAllTabsButton.setToolTipText(Constant.messages.getString("menu.view.tabs.hide"));
            DisplayUtils.scaleIcon(this.hideAllTabsButton);
            this.hideAllTabsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View.getSingleton().hideAllTabs();
                }
            });
        }
        return this.hideAllTabsButton;
    }

    private JToggleButton getShowTabIconNamesButton() {
        if (this.showTabIconNamesButton == null) {
            this.showTabIconNamesButton = new ZapToggleButton();
            this.showTabIconNamesButton.setIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/ui_tab_icon.png")));
            this.showTabIconNamesButton.setToolTipText(Constant.messages.getString("view.toolbar.showNames"));
            this.showTabIconNamesButton.setSelectedIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/ui_tab_text.png")));
            this.showTabIconNamesButton.setSelectedToolTipText(Constant.messages.getString("view.toolbar.showIcons"));
            this.showTabIconNamesButton.setSelected(Model.getSingleton().getOptionsParam().getViewParam().getShowTabNames());
            DisplayUtils.scaleIcon(this.showTabIconNamesButton);
            this.showTabIconNamesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean showTabNames = MainFrame.this.getShowTabIconNamesButton().isSelected();
                    MainFrame.this.setShowTabNames(showTabNames);
                    Model.getSingleton().getOptionsParam().getViewParam().setShowTabNames(showTabNames);
                    try {
                        Model.getSingleton().getOptionsParam().getViewParam().getConfig().save();
                    }
                    catch (ConfigurationException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        return this.showTabIconNamesButton;
    }

    private JToggleButton getExpandSelectLayoutButton() {
        if (this.expandSelectLayoutButton == null) {
            this.expandSelectLayoutButton = new JToggleButton(new ChangeWorkbenchLayoutAction(WorkbenchPanel.class.getResource("/resource/icon/expand_sites.png"), WorkbenchPanel.Layout.EXPAND_SELECT));
            this.expandSelectLayoutButton.setToolTipText(Constant.messages.getString("view.toolbar.expandSites"));
        }
        return this.expandSelectLayoutButton;
    }

    private JToggleButton getExpandStatusLayoutButton() {
        if (this.expandStatusLayoutButton == null) {
            this.expandStatusLayoutButton = new JToggleButton(new ChangeWorkbenchLayoutAction(WorkbenchPanel.class.getResource("/resource/icon/expand_info.png"), WorkbenchPanel.Layout.EXPAND_STATUS));
            this.expandStatusLayoutButton.setToolTipText(Constant.messages.getString("view.toolbar.expandInfo"));
        }
        return this.expandStatusLayoutButton;
    }

    private JToggleButton getFullLayoutButton() {
        if (this.fullLayoutButton == null) {
            this.fullLayoutButton = new JToggleButton(new ChangeWorkbenchLayoutAction(WorkbenchPanel.class.getResource("/resource/icon/expand_full.png"), WorkbenchPanel.Layout.FULL));
            this.fullLayoutButton.setToolTipText(Constant.messages.getString("view.toolbar.expandFull"));
        }
        return this.fullLayoutButton;
    }

    private ZapToggleButton getTabsResponsePanelPositionButton() {
        if (this.tabsResponsePanelPositionButton == null) {
            this.tabsResponsePanelPositionButton = new ZapToggleButton(new SetResponsePanelPositionAction(WorkbenchPanel.class.getResource("/resource/icon/layout_tabbed.png"), WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE));
            this.tabsResponsePanelPositionButton.setToolTipText(TABS_VIEW_TOOL_TIP);
        }
        return this.tabsResponsePanelPositionButton;
    }

    private ZapToggleButton getTabSideBySideResponsePanelPositionButton() {
        if (this.tabSideBySideResponsePanelPositionButton == null) {
            this.tabSideBySideResponsePanelPositionButton = new ZapToggleButton(new SetResponsePanelPositionAction(WorkbenchPanel.class.getResource("/resource/icon/layout_tabbed_split.png"), WorkbenchPanel.ResponsePanelPosition.TAB_SIDE_BY_SIDE));
            this.tabSideBySideResponsePanelPositionButton.setToolTipText(TAB_SIDE_BY_SIDE_VIEW_TOOL_TIP);
        }
        return this.tabSideBySideResponsePanelPositionButton;
    }

    private ZapToggleButton getPanelsResponsePanelPositionButton() {
        if (this.panelsResponsePanelPositionButton == null) {
            this.panelsResponsePanelPositionButton = new ZapToggleButton(new SetResponsePanelPositionAction(WorkbenchPanel.class.getResource("/resource/icon/layout_horizontal_split.png"), WorkbenchPanel.ResponsePanelPosition.PANELS_SIDE_BY_SIDE));
            this.panelsResponsePanelPositionButton.setToolTipText(SIDE_BY_SIDE_VIEW_TOOL_TIP);
            this.panelsResponsePanelPositionButton.setDisabledToolTipText(DISABLED_SIDE_BY_SIDE_VIEW_TOOL_TIP);
        }
        return this.panelsResponsePanelPositionButton;
    }

    private ZapToggleButton getAboveResponsePanelPositionButton() {
        if (this.aboveResponsePanelPositionButton == null) {
            this.aboveResponsePanelPositionButton = new ZapToggleButton(new SetResponsePanelPositionAction(WorkbenchPanel.class.getResource("/resource/icon/layout_vertical_split.png"), WorkbenchPanel.ResponsePanelPosition.PANEL_ABOVE));
            this.aboveResponsePanelPositionButton.setToolTipText(ABOVE_VIEW_TOOL_TIP);
            this.aboveResponsePanelPositionButton.setDisabledToolTipText(DISABLED_ABOVE_VIEW_TOOL_TIP);
        }
        return this.aboveResponsePanelPositionButton;
    }

    private PopupButton getLookAndFeelButton() {
        if (this.lookAndFeelButton == null) {
            this.lookAndFeelButton = new PopupButton(){
                private static final long serialVersionUID = 1L;

                @Override
                public List<String> getMenuItemNames() {
                    UIManager.LookAndFeelInfo[] looks;
                    ArrayList<String> list = new ArrayList<String>();
                    for (UIManager.LookAndFeelInfo look : looks = UIManager.getInstalledLookAndFeels()) {
                        list.add(look.getName());
                    }
                    return list;
                }

                @Override
                public void menuItemSelected(String option) {
                    UIManager.LookAndFeelInfo[] looks;
                    for (UIManager.LookAndFeelInfo look : looks = UIManager.getInstalledLookAndFeels()) {
                        if (!look.getName().equals(option)) continue;
                        MainFrame.this.options.getViewParam().setLookAndFeelInfo(look);
                    }
                }

                @Override
                public String getSelectedMenuItem() {
                    return MainFrame.this.options.getViewParam().getLookAndFeel();
                }
            };
            this.lookAndFeelButton.setIcon(new ImageIcon(WorkbenchPanel.class.getResource("/resource/icon/fugue/ui-color-picker-switch.png")));
            this.lookAndFeelButton.setToolTipText(Constant.messages.getString("view.toolbar.switchLookAndFeel"));
        }
        return this.lookAndFeelButton;
    }

    public MainFooterPanel getMainFooterPanel() {
        if (this.mainFooterPanel == null) {
            this.mainFooterPanel = new MainFooterPanel();
        }
        return this.mainFooterPanel;
    }

    @Deprecated
    public void changeDisplayOption(int displayOption) {
        this.setWorkbenchLayout(WorkbenchPanel.Layout.getLayout(displayOption));
    }

    public void applyViewOptions() {
        this.setMainToolbarVisible(this.options.getViewParam().isShowMainToolbar());
        this.setWorkbenchLayout(WorkbenchPanel.Layout.getLayout(this.options.getViewParam().getDisplayOption()));
        WorkbenchPanel.ResponsePanelPosition position = WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE;
        try {
            position = WorkbenchPanel.ResponsePanelPosition.valueOf(this.options.getViewParam().getResponsePanelPosition());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to restore the position of response panel: ", (Throwable)e);
        }
        this.setResponsePanelPosition(position);
        this.setShowTabNames(this.options.getViewParam().getShowTabNames());
        this.getMainFooterPanel().optionsChanged();
    }

    public void setWorkbenchLayout(WorkbenchPanel.Layout layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Parameter layout must not be null.");
        }
        if (this.workbenchLayout == layout) {
            return;
        }
        this.workbenchLayout = layout;
        switch (this.workbenchLayout) {
            case EXPAND_STATUS: {
                this.getExpandStatusLayoutButton().setSelected(true);
                this.setResponsePanelPositionButtonsEnabled(true);
                break;
            }
            case FULL: {
                this.getFullLayoutButton().setSelected(true);
                this.setResponsePanelPositionButtonsEnabled(false);
                break;
            }
            default: {
                this.getExpandSelectLayoutButton().setSelected(true);
                this.setResponsePanelPositionButtonsEnabled(true);
            }
        }
        this.getWorkbench().setWorkbenchLayout(this.workbenchLayout);
        this.options.getViewParam().setDisplayOption(this.workbenchLayout.getId());
    }

    private void setResponsePanelPositionButtonsEnabled(boolean enabled) {
        this.panelsResponsePanelPositionButton.setEnabled(enabled);
        this.aboveResponsePanelPositionButton.setEnabled(enabled);
    }

    public WorkbenchPanel.Layout getWorkbenchLayout() {
        return this.workbenchLayout;
    }

    public void setResponsePanelPosition(WorkbenchPanel.ResponsePanelPosition position) {
        if (position == null) {
            throw new IllegalArgumentException("Parameter position must not be null.");
        }
        if (this.responsePanelPosition == position) {
            return;
        }
        this.responsePanelPosition = position;
        switch (position) {
            case PANEL_ABOVE: {
                this.aboveResponsePanelPositionButton.setSelected(true);
                break;
            }
            case PANELS_SIDE_BY_SIDE: {
                this.panelsResponsePanelPositionButton.setSelected(true);
                break;
            }
            case TAB_SIDE_BY_SIDE: {
                this.tabSideBySideResponsePanelPositionButton.setSelected(true);
                break;
            }
            default: {
                this.tabsResponsePanelPositionButton.setSelected(true);
            }
        }
        this.getWorkbench().setResponsePanelPosition(this.responsePanelPosition);
        this.options.getViewParam().setResponsePanelPosition(this.responsePanelPosition.toString());
    }

    public WorkbenchPanel.ResponsePanelPosition getResponsePanelPosition() {
        return this.responsePanelPosition;
    }

    public void setShowTabNames(boolean showTabNames) {
        this.getWorkbench().toggleTabNames(showTabNames);
        this.getShowTabIconNamesButton().setSelected(showTabNames);
    }

    public void setTitle(Session session) {
        StringBuilder strBuilder = new StringBuilder();
        if (session != null) {
            strBuilder.append(session.getSessionName()).append(" - ");
            if (!session.isNewState()) {
                File file = new File(session.getFileName());
                strBuilder.append(file.getName().replaceAll(".session\\z", "")).append(" - ");
            }
        }
        strBuilder.append("OWASP ZAP").append(' ').append(Constant.PROGRAM_VERSION);
        super.setTitle(strBuilder.toString());
    }

    @Override
    @Deprecated
    public void setTitle(String title) {
        StringBuilder strBuilder = new StringBuilder();
        if (title != null && !title.isEmpty()) {
            strBuilder.append(title);
            strBuilder.append(" - ");
        }
        strBuilder.append("OWASP ZAP").append(' ').append(Constant.PROGRAM_VERSION);
        super.setTitle(strBuilder.toString());
    }

    public void setMainToolbarVisible(boolean visible) {
        this.getMainToolbarPanel().setVisible(visible);
    }

    private class SetResponsePanelPositionAction
    extends AbstractAction {
        private static final long serialVersionUID = 756133292459364854L;
        private final WorkbenchPanel.ResponsePanelPosition position;

        public SetResponsePanelPositionAction(URL iconLocation, WorkbenchPanel.ResponsePanelPosition position) {
            super("", new ImageIcon(iconLocation));
            this.position = position;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.setResponsePanelPosition(this.position);
        }
    }

    private class ChangeWorkbenchLayoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 8323387638733162321L;
        private final WorkbenchPanel.Layout layout;

        public ChangeWorkbenchLayoutAction(URL iconURL, WorkbenchPanel.Layout layout) {
            super("", DisplayUtils.getScaledIcon(new ImageIcon(iconURL)));
            this.layout = layout;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MainFrame.this.setWorkbenchLayout(this.layout);
        }
    }
}

