/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.typehandling;

import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.codehaus.groovy.runtime.typehandling.IntegerCache;

public class DefaultTypeTransformation {
    protected static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected static final BigInteger ONE_NEG = new BigInteger("-1");

    public static byte byteUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.byteValue();
    }

    public static char charUnbox(Object value) {
        return DefaultTypeTransformation.castToChar(value);
    }

    public static short shortUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.shortValue();
    }

    public static int intUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.intValue();
    }

    public static boolean booleanUnbox(Object value) {
        return DefaultTypeTransformation.castToBoolean(value);
    }

    public static long longUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.longValue();
    }

    public static float floatUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.floatValue();
    }

    public static double doubleUnbox(Object value) {
        Number n = DefaultTypeTransformation.castToNumber(value);
        return n.doubleValue();
    }

    public static Object box(boolean value) {
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object box(byte value) {
        return new Byte(value);
    }

    public static Object box(char value) {
        return new Character(value);
    }

    public static Object box(short value) {
        return new Short(value);
    }

    public static Object box(int value) {
        return IntegerCache.integerValue(value);
    }

    public static Object box(long value) {
        return new Long(value);
    }

    public static Object box(float value) {
        return new Float(value);
    }

    public static Object box(double value) {
        return new Double(value);
    }

    public static Number castToNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof String) {
            String c = (String)object;
            if (c.length() == 1) {
                return new Integer(c.charAt(0));
            }
            throw new GroovyCastException((Object)c, Integer.class);
        }
        throw new GroovyCastException(object, Number.class);
    }

    public static boolean castToBoolean(Object object) {
        if (object instanceof Boolean) {
            Boolean booleanValue = (Boolean)object;
            return booleanValue;
        }
        if (object instanceof Matcher) {
            Matcher matcher = (Matcher)object;
            RegexSupport.setLastMatcher(matcher);
            return matcher.find();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return !collection.isEmpty();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return !map.isEmpty();
        }
        if (object instanceof String || object instanceof GString) {
            String string = object.toString();
            return string.length() > 0;
        }
        if (object instanceof Character) {
            Character c = (Character)object;
            return c.charValue() != '\u0000';
        }
        if (object instanceof Number) {
            Number n = (Number)object;
            return n.doubleValue() != 0.0;
        }
        return object != null;
    }

    public static char castToChar(Object object) {
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Number) {
            Number value = (Number)object;
            return (char)value.intValue();
        }
        String text = object.toString();
        if (text.length() == 1) {
            return text.charAt(0);
        }
        throw new GroovyCastException((Object)text, Character.TYPE);
    }

    public static Object castToType(Object object, Class type) {
        if (object == null) {
            return null;
        }
        if (type == object.getClass()) {
            return object;
        }
        if (type.isArray()) {
            return DefaultTypeTransformation.asArray(object, type);
        }
        if (type.isInstance(object)) {
            return object;
        }
        if (Collection.class.isAssignableFrom(type) && object.getClass().isArray()) {
            ArrayList<Object> answer;
            int modifiers = type.getModifiers();
            if (type.isAssignableFrom(ArrayList.class) && (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers))) {
                answer = new ArrayList<Object>();
            } else {
                try {
                    answer = (ArrayList<Object>)type.newInstance();
                }
                catch (Exception e) {
                    throw new GroovyCastException("Could not instantiate instance of: " + type.getName() + ". Reason: " + e);
                }
            }
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(object, i);
                answer.add(element);
            }
            return answer;
        }
        if (type == String.class) {
            return object.toString();
        }
        if (type == Character.class) {
            return DefaultTypeTransformation.box(DefaultTypeTransformation.castToChar(object));
        }
        if (type == Boolean.class) {
            return DefaultTypeTransformation.box(DefaultTypeTransformation.castToBoolean(object));
        }
        if (Number.class.isAssignableFrom(type)) {
            Number n = DefaultTypeTransformation.castToNumber(object);
            if (type == Byte.class) {
                return new Byte(n.byteValue());
            }
            if (type == Character.class) {
                return new Character((char)n.intValue());
            }
            if (type == Short.class) {
                return new Short(n.shortValue());
            }
            if (type == Integer.class) {
                return new Integer(n.intValue());
            }
            if (type == Long.class) {
                return new Long(n.longValue());
            }
            if (type == Float.class) {
                return new Float(n.floatValue());
            }
            if (type == Double.class) {
                Double answer = new Double(n.doubleValue());
                if (!(n instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                    throw new GroovyRuntimeException("Automatic coercion of " + n.getClass().getName() + " value " + n + " to double failed.  Value is out of range.");
                }
                return answer;
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(n.toString());
            }
            if (type == BigInteger.class) {
                if (object instanceof Float || object instanceof Double) {
                    BigDecimal bd = new BigDecimal(n.doubleValue());
                    return bd.toBigInteger();
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).toBigInteger();
                }
                return new BigInteger(n.toString());
            }
        } else if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.booleanUnbox(object));
            }
            if (type == Byte.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.byteUnbox(object));
            }
            if (type == Character.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.charUnbox(object));
            }
            if (type == Short.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.shortUnbox(object));
            }
            if (type == Integer.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.intUnbox(object));
            }
            if (type == Long.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.longUnbox(object));
            }
            if (type == Float.TYPE) {
                return DefaultTypeTransformation.box(DefaultTypeTransformation.floatUnbox(object));
            }
            if (type == Double.TYPE) {
                Double answer = new Double(DefaultTypeTransformation.doubleUnbox(object));
                if (!(object instanceof Double || answer != Double.NEGATIVE_INFINITY && answer != Double.POSITIVE_INFINITY)) {
                    throw new GroovyRuntimeException("Automatic coercion of " + object.getClass().getName() + " value " + object + " to double failed.  Value is out of range.");
                }
                return answer;
            }
        }
        Object[] args = null;
        if (object instanceof Collection) {
            Collection list = (Collection)object;
            args = list.toArray();
        } else if (object instanceof Object[]) {
            args = (Object[])object;
        } else if (object instanceof Map) {
            args = new Object[]{object};
        }
        if (args != null) {
            try {
                return InvokerHelper.invokeConstructorOf(type, (Object)args);
            }
            catch (InvokerInvocationException iie) {
                throw iie;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new GroovyCastException(object, type);
    }

    public static Object asArray(Object object, Class type) {
        Collection list = DefaultTypeTransformation.asCollection(object);
        int size = list.size();
        Class<?> elementType = type.getComponentType();
        Object array = Array.newInstance(elementType, size);
        int idx = 0;
        if (Boolean.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setBoolean(array, idx, DefaultTypeTransformation.booleanUnbox(element));
                ++idx;
            }
        } else if (Byte.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setByte(array, idx, DefaultTypeTransformation.byteUnbox(element));
                ++idx;
            }
        } else if (Character.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setChar(array, idx, DefaultTypeTransformation.charUnbox(element));
                ++idx;
            }
        } else if (Double.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setDouble(array, idx, DefaultTypeTransformation.doubleUnbox(element));
                ++idx;
            }
        } else if (Float.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setFloat(array, idx, DefaultTypeTransformation.floatUnbox(element));
                ++idx;
            }
        } else if (Integer.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setInt(array, idx, DefaultTypeTransformation.intUnbox(element));
                ++idx;
            }
        } else if (Long.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setLong(array, idx, DefaultTypeTransformation.longUnbox(element));
                ++idx;
            }
        } else if (Short.TYPE.equals(elementType)) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Array.setShort(array, idx, DefaultTypeTransformation.shortUnbox(element));
                ++idx;
            }
        } else {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                Object coercedElement = DefaultTypeTransformation.castToType(element, elementType);
                Array.set(array, idx, coercedElement);
                ++idx;
            }
        }
        return array;
    }

    public static Collection asCollection(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet();
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return DefaultTypeTransformation.primitiveArrayToList(value);
            }
            return Arrays.asList((Object[])value);
        }
        if (value instanceof MethodClosure) {
            MethodClosure method = (MethodClosure)value;
            IteratorClosureAdapter adapter = new IteratorClosureAdapter(method.getDelegate());
            method.call(adapter);
            return adapter.asList();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.toList((String)value);
        }
        if (value instanceof File) {
            try {
                return DefaultGroovyMethods.readLines((File)value);
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("Error reading file: " + value, e);
            }
        }
        return Collections.singletonList(value);
    }

    public static List primitiveArrayToList(Object array) {
        int size = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static int compareTo(Object left, Object right) {
        if (left == right) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof Comparable) {
            if (left instanceof Number) {
                if (DefaultTypeTransformation.isValidCharacterString(right)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
                if (right instanceof Character || right instanceof Number) {
                    return DefaultGroovyMethods.compareTo((Number)left, DefaultTypeTransformation.castToNumber(right));
                }
            } else if (left instanceof Character) {
                if (DefaultTypeTransformation.isValidCharacterString(right)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
                if (right instanceof Number) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
            } else if (right instanceof Number) {
                if (DefaultTypeTransformation.isValidCharacterString(left)) {
                    return DefaultTypeTransformation.castToChar(left) - DefaultTypeTransformation.castToChar(right);
                }
            } else {
                if (left instanceof String && right instanceof Character) {
                    return ((String)left).compareTo(right.toString());
                }
                if (left instanceof String && right instanceof GString) {
                    return ((String)left).compareTo(right.toString());
                }
            }
            Comparable comparable = (Comparable)left;
            return comparable.compareTo(right);
        }
        if (left.getClass().isArray()) {
            Collection leftList = DefaultTypeTransformation.asCollection(left);
            if (right.getClass().isArray()) {
                right = DefaultTypeTransformation.asCollection(right);
            }
            return ((Comparable)((Object)leftList)).compareTo(right);
        }
        throw new GroovyRuntimeException("Cannot compare values: " + left + " and " + right);
    }

    public static boolean compareEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Comparable) {
            return DefaultTypeTransformation.compareTo(left, right) == 0;
        }
        if (left instanceof List && right instanceof List) {
            return DefaultGroovyMethods.equals((List)left, (List)right);
        }
        return left.equals(right);
    }

    private static boolean isValidCharacterString(Object value) {
        String s;
        return value instanceof String && (s = (String)value).length() == 1;
    }

    public static Object[] convertPrimitiveArray(Object a, Class type) {
        Object[] ans;
        block25: {
            String elemType;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block24: {
                                        ans = null;
                                        elemType = type.getName();
                                        if (!elemType.equals("int")) break block24;
                                        if (a.getClass().getName().equals("[Ljava.lang.Integer;")) {
                                            ans = (Integer[])a;
                                        } else {
                                            int[] ia = (int[])a;
                                            ans = new Integer[ia.length];
                                            for (int i = 0; i < ia.length; ++i) {
                                                int e = ia[i];
                                                ans[i] = IntegerCache.integerValue(e);
                                            }
                                        }
                                        break block25;
                                    }
                                    if (!elemType.equals("char")) break block26;
                                    if (a.getClass().getName().equals("[Ljava.lang.Character;")) {
                                        ans = (Character[])a;
                                    } else {
                                        char[] ia = (char[])a;
                                        ans = new Character[ia.length];
                                        for (int i = 0; i < ia.length; ++i) {
                                            char e = ia[i];
                                            ans[i] = new Character(e);
                                        }
                                    }
                                    break block25;
                                }
                                if (!elemType.equals("boolean")) break block27;
                                if (a.getClass().getName().equals("[Ljava.lang.Boolean;")) {
                                    ans = (Boolean[])a;
                                } else {
                                    boolean[] ia = (boolean[])a;
                                    ans = new Boolean[ia.length];
                                    for (int i = 0; i < ia.length; ++i) {
                                        boolean e = ia[i];
                                        ans[i] = new Boolean(e);
                                    }
                                }
                                break block25;
                            }
                            if (!elemType.equals("byte")) break block28;
                            if (a.getClass().getName().equals("[Ljava.lang.Byte;")) {
                                ans = (Byte[])a;
                            } else {
                                byte[] ia = (byte[])a;
                                ans = new Byte[ia.length];
                                for (int i = 0; i < ia.length; ++i) {
                                    byte e = ia[i];
                                    ans[i] = new Byte(e);
                                }
                            }
                            break block25;
                        }
                        if (!elemType.equals("short")) break block29;
                        if (a.getClass().getName().equals("[Ljava.lang.Short;")) {
                            ans = (Short[])a;
                        } else {
                            short[] ia = (short[])a;
                            ans = new Short[ia.length];
                            for (int i = 0; i < ia.length; ++i) {
                                short e = ia[i];
                                ans[i] = new Short(e);
                            }
                        }
                        break block25;
                    }
                    if (!elemType.equals("float")) break block30;
                    if (a.getClass().getName().equals("[Ljava.lang.Float;")) {
                        ans = (Float[])a;
                    } else {
                        float[] ia = (float[])a;
                        ans = new Float[ia.length];
                        for (int i = 0; i < ia.length; ++i) {
                            float e = ia[i];
                            ans[i] = new Float(e);
                        }
                    }
                    break block25;
                }
                if (!elemType.equals("long")) break block31;
                if (a.getClass().getName().equals("[Ljava.lang.Long;")) {
                    ans = (Long[])a;
                } else {
                    long[] ia = (long[])a;
                    ans = new Long[ia.length];
                    for (int i = 0; i < ia.length; ++i) {
                        long e = ia[i];
                        ans[i] = new Long(e);
                    }
                }
                break block25;
            }
            if (!elemType.equals("double")) break block25;
            if (a.getClass().getName().equals("[Ljava.lang.Double;")) {
                ans = (Double[])a;
            } else {
                double[] ia = (double[])a;
                ans = new Double[ia.length];
                for (int i = 0; i < ia.length; ++i) {
                    double e = ia[i];
                    ans[i] = new Double(e);
                }
            }
        }
        return ans;
    }

    public static int[] convertToIntArray(Object a) {
        int[] ans = null;
        if (a.getClass().getName().equals("[I")) {
            ans = (int[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new int[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Number)ia[i]).intValue();
            }
        }
        return ans;
    }

    public static boolean[] convertToBooleanArray(Object a) {
        boolean[] ans = null;
        if (a.getClass().getName().equals("[Z")) {
            ans = (boolean[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new boolean[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = (Boolean)ia[i];
            }
        }
        return ans;
    }

    public static byte[] convertToByteArray(Object a) {
        byte[] ans = null;
        if (a.getClass().getName().equals("[B")) {
            ans = (byte[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new byte[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Number)ia[i]).byteValue();
            }
        }
        return ans;
    }

    public static short[] convertToShortArray(Object a) {
        short[] ans = null;
        if (a.getClass().getName().equals("[S")) {
            ans = (short[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new short[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                ans[i] = ((Number)ia[i]).shortValue();
            }
        }
        return ans;
    }

    public static char[] convertToCharArray(Object a) {
        char[] ans = null;
        if (a.getClass().getName().equals("[C")) {
            ans = (char[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new char[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Character)ia[i]).charValue();
            }
        }
        return ans;
    }

    public static long[] convertToLongArray(Object a) {
        long[] ans = null;
        if (a.getClass().getName().equals("[J")) {
            ans = (long[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new long[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Number)ia[i]).longValue();
            }
        }
        return ans;
    }

    public static float[] convertToFloatArray(Object a) {
        float[] ans = null;
        if (a.getClass().getName().equals("[F")) {
            ans = (float[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new float[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Number)ia[i]).floatValue();
            }
        }
        return ans;
    }

    public static double[] convertToDoubleArray(Object a) {
        double[] ans = null;
        if (a.getClass().getName().equals("[D")) {
            ans = (double[])a;
        } else {
            Object[] ia = (Object[])a;
            ans = new double[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                if (ia[i] == null) continue;
                ans[i] = ((Number)ia[i]).doubleValue();
            }
        }
        return ans;
    }

    public static Object convertToPrimitiveArray(Object a, Class type) {
        if (type == Byte.TYPE) {
            return DefaultTypeTransformation.convertToByteArray(a);
        }
        if (type == Boolean.TYPE) {
            return DefaultTypeTransformation.convertToBooleanArray(a);
        }
        if (type == Short.TYPE) {
            return DefaultTypeTransformation.convertToShortArray(a);
        }
        if (type == Character.TYPE) {
            return DefaultTypeTransformation.convertToCharArray(a);
        }
        if (type == Integer.TYPE) {
            return DefaultTypeTransformation.convertToIntArray(a);
        }
        if (type == Long.TYPE) {
            return DefaultTypeTransformation.convertToLongArray(a);
        }
        if (type == Float.TYPE) {
            return DefaultTypeTransformation.convertToFloatArray(a);
        }
        if (type == Double.TYPE) {
            return DefaultTypeTransformation.convertToDoubleArray(a);
        }
        return a;
    }
}

