/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.linux.XVisualInfo;

public class GLXSGIXFBConfig {
    public static final int GLX_DRAWABLE_TYPE_SGIX = 32784;
    public static final int GLX_RENDER_TYPE_SGIX = 32785;
    public static final int GLX_X_RENDERABLE_SGIX = 32786;
    public static final int GLX_FBCONFIG_ID_SGIX = 32787;
    public static final int GLX_SCREEN_EXT = 32780;
    public static final int GLX_WINDOW_BIT_SGIX = 1;
    public static final int GLX_PIXMAP_BIT_SGIX = 2;
    public static final int GLX_RGBA_BIT_SGIX = 1;
    public static final int GLX_COLOR_INDEX_BIT_SGIX = 2;
    public static final int GLX_RGBA_TYPE_SGIX = 32788;
    public static final int GLX_COLOR_INDEX_TYPE_SGIX = 32789;

    protected GLXSGIXFBConfig() {
        throw new UnsupportedOperationException();
    }

    public static int nglXGetFBConfigAttribSGIX(long display, long config, int attribute, long value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttribSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPPI((long)display, (long)config, (int)attribute, (long)value, (long)__functionAddress);
    }

    public static int glXGetFBConfigAttribSGIX(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfigSGIX") long config, int attribute, @NativeType(value="int *") IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)value, (int)1);
        }
        return GLXSGIXFBConfig.nglXGetFBConfigAttribSGIX(display, config, attribute, MemoryUtil.memAddress((IntBuffer)value));
    }

    public static long nglXChooseFBConfigSGIX(long display, int screen, long attrib_list, long nelements) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfigSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
        }
        return JNI.callPPPP((long)display, (int)screen, (long)attrib_list, (long)nelements, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="GLXFBConfigSGIX *")
    public static PointerBuffer glXChooseFBConfigSGIX(@NativeType(value="Display *") long display, int screen, @Nullable @NativeType(value="int const *") IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe((IntBuffer)attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = GLXSGIXFBConfig.nglXChooseFBConfigSGIX(display, screen, MemoryUtil.memAddressSafe((IntBuffer)attrib_list), MemoryUtil.memAddress((IntBuffer)nelements));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="GLXPixmap")
    public static long glXCreateGLXPixmapWithConfigSGIX(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, @NativeType(value="Pixmap") long pixmap) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateGLXPixmapWithConfigSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPNP((long)display, (long)config, (long)pixmap, (long)__functionAddress);
    }

    @NativeType(value="GLXContext")
    public static long glXCreateContextWithConfigSGIX(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config, int render_type, @NativeType(value="GLXContext") long share_list, @NativeType(value="Bool") boolean direct) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXCreateContextWithConfigSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.check((long)share_list);
        }
        return JNI.callPPPP((long)display, (long)config, (int)render_type, (long)share_list, (int)(direct ? 1 : 0), (long)__functionAddress);
    }

    public static long nglXGetVisualFromFBConfigSGIX(long display, long config) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetVisualFromFBConfigSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
        }
        return JNI.callPPP((long)display, (long)config, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="XVisualInfo *")
    public static XVisualInfo glXGetVisualFromFBConfigSGIX(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfig") long config) {
        long __result = GLXSGIXFBConfig.nglXGetVisualFromFBConfigSGIX(display, config);
        return XVisualInfo.createSafe((long)__result);
    }

    public static long nglXGetFBConfigFromVisualSGIX(long display, long vis) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigFromVisualSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            XVisualInfo.validate((long)vis);
        }
        return JNI.callPPP((long)display, (long)vis, (long)__functionAddress);
    }

    @NativeType(value="GLXFBConfigSGIX")
    public static long glXGetFBConfigFromVisualSGIX(@NativeType(value="Display *") long display, @NativeType(value="XVisualInfo *") XVisualInfo vis) {
        return GLXSGIXFBConfig.nglXGetFBConfigFromVisualSGIX(display, vis.address());
    }

    public static int glXGetFBConfigAttribSGIX(@NativeType(value="Display *") long display, @NativeType(value="GLXFBConfigSGIX") long config, int attribute, @NativeType(value="int *") int[] value) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXGetFBConfigAttribSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.check((long)config);
            Checks.check((int[])value, (int)1);
        }
        return JNI.callPPPI((long)display, (long)config, (int)attribute, (int[])value, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="GLXFBConfigSGIX *")
    public static PointerBuffer glXChooseFBConfigSGIX(@NativeType(value="Display *") long display, int screen, @Nullable @NativeType(value="int const *") int[] attrib_list) {
        long __functionAddress = GL.getCapabilitiesGLXClient().glXChooseFBConfigSGIX;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)display);
            Checks.checkNTSafe((int[])attrib_list);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        IntBuffer nelements = stack.callocInt(1);
        try {
            long __result = JNI.callPPPP((long)display, (int)screen, (int[])attrib_list, (long)MemoryUtil.memAddress((IntBuffer)nelements), (long)__functionAddress);
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)nelements.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }
}

