/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_hlsl_root_constants")
public class SpvcHlslRootConstants
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int START;
    public static final int END;
    public static final int BINDING;
    public static final int SPACE;

    public SpvcHlslRootConstants(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcHlslRootConstants.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int start() {
        return SpvcHlslRootConstants.nstart(this.address());
    }

    @NativeType(value="unsigned int")
    public int end() {
        return SpvcHlslRootConstants.nend(this.address());
    }

    @NativeType(value="unsigned int")
    public int binding() {
        return SpvcHlslRootConstants.nbinding(this.address());
    }

    @NativeType(value="unsigned int")
    public int space() {
        return SpvcHlslRootConstants.nspace(this.address());
    }

    public SpvcHlslRootConstants start(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nstart(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants end(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nend(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants binding(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nbinding(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants space(@NativeType(value="unsigned int") int value) {
        SpvcHlslRootConstants.nspace(this.address(), value);
        return this;
    }

    public SpvcHlslRootConstants set(int start, int end, int binding, int space) {
        this.start(start);
        this.end(end);
        this.binding(binding);
        this.space(space);
        return this;
    }

    public SpvcHlslRootConstants set(SpvcHlslRootConstants src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcHlslRootConstants malloc() {
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcHlslRootConstants calloc() {
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcHlslRootConstants create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcHlslRootConstants create(long address) {
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)address);
    }

    @Nullable
    public static SpvcHlslRootConstants createSafe(long address) {
        return address == 0L ? null : (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcHlslRootConstants.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcHlslRootConstants.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcHlslRootConstants malloc(MemoryStack stack) {
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcHlslRootConstants calloc(MemoryStack stack) {
        return (SpvcHlslRootConstants)SpvcHlslRootConstants.wrap(SpvcHlslRootConstants.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcHlslRootConstants.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nstart(long struct) {
        return UNSAFE.getInt(null, struct + (long)START);
    }

    public static int nend(long struct) {
        return UNSAFE.getInt(null, struct + (long)END);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nspace(long struct) {
        return UNSAFE.getInt(null, struct + (long)SPACE);
    }

    public static void nstart(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)START, value);
    }

    public static void nend(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)END, value);
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void nspace(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SPACE, value);
    }

    static {
        Struct.Layout layout = SpvcHlslRootConstants.__struct((Struct.Member[])new Struct.Member[]{SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4), SpvcHlslRootConstants.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        START = layout.offsetof(0);
        END = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        SPACE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcHlslRootConstants, Buffer>
    implements NativeResource {
        private static final SpvcHlslRootConstants ELEMENT_FACTORY = SpvcHlslRootConstants.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcHlslRootConstants getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int start() {
            return SpvcHlslRootConstants.nstart(this.address());
        }

        @NativeType(value="unsigned int")
        public int end() {
            return SpvcHlslRootConstants.nend(this.address());
        }

        @NativeType(value="unsigned int")
        public int binding() {
            return SpvcHlslRootConstants.nbinding(this.address());
        }

        @NativeType(value="unsigned int")
        public int space() {
            return SpvcHlslRootConstants.nspace(this.address());
        }

        public Buffer start(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nstart(this.address(), value);
            return this;
        }

        public Buffer end(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nend(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nbinding(this.address(), value);
            return this;
        }

        public Buffer space(@NativeType(value="unsigned int") int value) {
            SpvcHlslRootConstants.nspace(this.address(), value);
            return this;
        }
    }
}

