/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.model.container;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.model.container.ContainerEntryComparator;
import org.jd.gui.spi.ContainerFactory;
import org.jd.gui.util.exception.ExceptionUtil;

public class GenericContainer
implements Container {
    protected static final long TIMESTAMP = System.currentTimeMillis();
    protected static long tmpFileCounter = 0L;
    protected API api;
    protected int rootNameCount;
    protected Container.Entry root;

    public GenericContainer(API api, Container.Entry parentEntry, Path rootPath) {
        block2: {
            try {
                URI uri = parentEntry.getUri();
                this.api = api;
                this.rootNameCount = rootPath.getNameCount();
                this.root = new Entry(parentEntry, rootPath, new URI(uri.getScheme(), uri.getHost(), uri.getPath() + "!/", null)){

                    @Override
                    public Entry newChildEntry(Path fsPath) {
                        return new Entry(this.parent, fsPath, null);
                    }
                };
            }
            catch (URISyntaxException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public String getType() {
        return "generic";
    }

    @Override
    public Container.Entry getRoot() {
        return this.root;
    }

    protected class Entry
    implements Container.Entry {
        protected Container.Entry parent;
        protected Path fsPath;
        protected String strPath;
        protected URI uri;
        protected Boolean isDirectory;
        protected Collection<Container.Entry> children;

        public Entry(Container.Entry parent, Path fsPath, URI uri) {
            this.parent = parent;
            this.fsPath = fsPath;
            this.strPath = null;
            this.uri = uri;
            this.isDirectory = null;
            this.children = null;
        }

        public Entry newChildEntry(Path fsPath) {
            return new Entry(this, fsPath, null);
        }

        @Override
        public Container getContainer() {
            return GenericContainer.this;
        }

        @Override
        public Container.Entry getParent() {
            return this.parent;
        }

        @Override
        public URI getUri() {
            block3: {
                if (this.uri == null) {
                    try {
                        URI rootUri = GenericContainer.this.root.getUri();
                        this.uri = new URI(rootUri.getScheme(), rootUri.getHost(), rootUri.getPath() + this.getPath(), null);
                    }
                    catch (URISyntaxException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                        throw new AssertionError();
                    }
                }
            }
            return this.uri;
        }

        @Override
        public String getPath() {
            if (this.strPath == null) {
                int nameCount = this.fsPath.getNameCount();
                if (GenericContainer.this.rootNameCount == nameCount) {
                    this.strPath = "";
                } else {
                    this.strPath = this.fsPath.subpath(GenericContainer.this.rootNameCount, nameCount).toString().replace(this.fsPath.getFileSystem().getSeparator(), "/");
                    int strPathLength = this.strPath.length();
                    if (strPathLength > 0 && this.strPath.charAt(strPathLength - 1) == '/') {
                        this.strPath = this.strPath.substring(0, strPathLength - 1);
                    }
                }
            }
            return this.strPath;
        }

        @Override
        public boolean isDirectory() {
            if (this.isDirectory == null) {
                this.isDirectory = Files.isDirectory(this.fsPath, new LinkOption[0]);
            }
            return this.isDirectory;
        }

        @Override
        public long length() {
            try {
                return Files.size(this.fsPath);
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace(e));
                return -1L;
            }
        }

        @Override
        public InputStream getInputStream() {
            try {
                return Files.newInputStream(this.fsPath, new OpenOption[0]);
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace(e));
                return null;
            }
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            block3: {
                if (this.children == null) {
                    try {
                        this.children = Files.isDirectory(this.fsPath, new LinkOption[0]) ? this.loadChildrenFromDirectoryEntry() : this.loadChildrenFromFileEntry();
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block3;
                        throw new AssertionError();
                    }
                }
            }
            return this.children;
        }

        protected Collection<Container.Entry> loadChildrenFromDirectoryEntry() throws IOException {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.fsPath);){
                ArrayList<Container.Entry> children = new ArrayList<Container.Entry>();
                int parentNameCount = this.fsPath.getNameCount();
                for (Path subPath : stream) {
                    if (subPath.getNameCount() <= parentNameCount) continue;
                    children.add(this.newChildEntry(subPath));
                }
                children.sort(ContainerEntryComparator.COMPARATOR);
                Collection collection = Collections.unmodifiableCollection(children);
                return collection;
            }
        }

        protected Collection<Container.Entry> loadChildrenFromFileEntry() throws IOException {
            Container container;
            Path rootPath;
            ContainerFactory containerFactory;
            Iterator<Path> rootDirectories;
            StringBuilder suffix = new StringBuilder(".").append(TIMESTAMP).append('.').append(tmpFileCounter++).append('.').append(this.fsPath.getFileName().toString());
            File tmpFile = File.createTempFile("jd-gui.tmp.", suffix.toString());
            Path tmpPath = Paths.get(tmpFile.toURI());
            tmpFile.delete();
            tmpFile.deleteOnExit();
            Files.copy(this.fsPath, tmpPath, new CopyOption[0]);
            FileSystem subFileSystem = FileSystems.newFileSystem(tmpPath, null);
            if (subFileSystem != null && (rootDirectories = subFileSystem.getRootDirectories().iterator()).hasNext() && (containerFactory = GenericContainer.this.api.getContainerFactory(rootPath = rootDirectories.next())) != null && (container = containerFactory.make(GenericContainer.this.api, this, rootPath)) != null) {
                return container.getRoot().getChildren();
            }
            tmpFile.delete();
            return Collections.emptyList();
        }
    }
}

