/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.writetolog;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.writetolog.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryWriteToLog
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String logmessage;
    public int loglevel;
    private String logsubject;

    public JobEntryWriteToLog(String n) {
        super(n, "");
        this.logmessage = null;
        this.logsubject = null;
        this.setJobEntryType(JobEntryType.WRITE_TO_LOG);
    }

    public JobEntryWriteToLog() {
        this("");
    }

    public JobEntryWriteToLog(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryWriteToLog je = (JobEntryWriteToLog)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"logmessage", (String)this.logmessage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"loglevel", (String)LogWriter.getLogLevelDesc((int)this.loglevel)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logsubject", (String)this.logsubject));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.logmessage = XMLHandler.getTagValue((Node)entrynode, (String)"logmessage");
            this.loglevel = LogWriter.getLogLevel((String)XMLHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.logsubject = XMLHandler.getTagValue((Node)entrynode, (String)"logsubject");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("WriteToLog.Error.UnableToLoadFromXML.Label"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.logmessage = rep.getJobEntryAttributeString(id_jobentry, "logmessage");
            this.loglevel = LogWriter.getLogLevel((String)rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            this.logsubject = rep.getJobEntryAttributeString(id_jobentry, "logsubject");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("WriteToLog.Error.UnableToLoadFromRepository.Label") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logmessage", this.logmessage);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc((int)this.loglevel));
            rep.saveJobEntryAttribute(id_job, this.getID(), "logsubject", this.logsubject);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("WriteToLog.Error.UnableToSaveToRepository.Label") + id_job, (Throwable)dbe);
        }
    }

    public boolean evaluate(Result result) {
        LogWriter log = LogWriter.getInstance();
        try {
            ++this.loglevel;
            if (this.loglevel == 1) {
                log.logError(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            } else if (this.loglevel == 2) {
                log.logMinimal(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            } else if (this.loglevel == 3) {
                log.logBasic(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            } else if (this.loglevel == 4) {
                log.logDetailed(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            } else if (this.loglevel == 5) {
                log.logDebug(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            } else if (this.loglevel == 6) {
                log.logRowlevel(Const.CR + this.getRealLogSubject() + Const.CR, this.getRealLogMessage() + Const.CR, new Object[0]);
            }
            return true;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            log.logError(Messages.getString("WriteToLog.Error.Label"), Messages.getString("WriteToLog.Error.Description") + " : " + e.toString(), new Object[0]);
            return false;
        }
    }

    @Override
    public Result execute(Result prev_result, int nr, Repository rep, Job parentJob) {
        prev_result.setResult(this.evaluate(prev_result));
        return prev_result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public String getRealLogMessage() {
        return this.environmentSubstitute(Const.NVL((String)this.getLogMessage(), (String)""));
    }

    public String getRealLogSubject() {
        return this.environmentSubstitute(Const.NVL((String)this.getLogSubject(), (String)""));
    }

    public String getLogMessage() {
        if (this.logmessage == null) {
            this.logmessage = "";
        }
        return this.logmessage;
    }

    public String getLogSubject() {
        if (this.logsubject == null) {
            this.logsubject = "";
        }
        return this.logsubject;
    }

    public void setLogMessage(String s) {
        this.logmessage = s;
    }

    public void setLogSubject(String logsubjectin) {
        this.logsubject = logsubjectin;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.addOkRemark(this, "LogMessage", remarks);
        JobEntryValidatorUtils.addOkRemark(this, "LogSubject", remarks);
    }
}

