/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDumpSegment;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.LoadClassSegment;
import org.graalvm.visualvm.lib.jfluid.heap.StackFrameSegment;
import org.graalvm.visualvm.lib.jfluid.heap.StackTraceSegment;
import org.graalvm.visualvm.lib.jfluid.heap.StringSegment;

class TagBounds {
    final int tag;
    final long startOffset;
    long endOffset;

    TagBounds(int t, long start, long end) {
        this.tag = t;
        this.startOffset = start;
        this.endOffset = end;
    }

    TagBounds union(TagBounds otherTagBounds) {
        if (otherTagBounds == null) {
            return this;
        }
        long start = Math.min(this.startOffset, otherTagBounds.startOffset);
        long end = Math.max(this.endOffset, otherTagBounds.endOffset);
        return new TagBounds(-1, start, end);
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.tag);
        out.writeLong(this.startOffset);
        out.writeLong(this.endOffset);
    }

    TagBounds(DataInputStream dis) throws IOException {
        this.tag = dis.readInt();
        this.startOffset = dis.readLong();
        this.endOffset = dis.readLong();
    }

    static void writeToStream(TagBounds[] bounds, DataOutputStream out) throws IOException {
        int tags = 0;
        for (TagBounds bound : bounds) {
            if (bound == null) continue;
            ++tags;
        }
        out.writeInt(tags);
        for (TagBounds bound : bounds) {
            if (bound == null) continue;
            bound.writeToStream(out);
        }
    }

    static void readFromStream(DataInputStream dis, HprofHeap heap, TagBounds[] heapTagBounds) throws IOException {
        int tags = dis.readInt();
        for (int i = 0; i < tags; ++i) {
            int tag = dis.readInt();
            long startOffset = dis.readLong();
            long endOffset = dis.readLong();
            TagBounds newBounds = tag == 2 ? new LoadClassSegment(heap, startOffset, endOffset) : (tag == 1 ? new StringSegment(heap, startOffset, endOffset) : (tag == 5 ? new StackTraceSegment(heap, startOffset, endOffset) : (tag == 4 ? new StackFrameSegment(heap, startOffset, endOffset) : (tag == 32 ? new ClassDumpSegment(heap, startOffset, endOffset, dis) : new TagBounds(tag, startOffset, endOffset)))));
            heapTagBounds[newBounds.tag] = newBounds;
        }
    }
}

