/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.util.DoublePrecision;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.SafeEncoder;

public final class SearchBuilderFactory {
    public static final Builder<Map<String, Object>> SEARCH_PROFILE_PROFILE = new Builder<Map<String, Object>>(){
        private final String ITERATORS_PROFILE_STR = "Iterators profile";
        private final String CHILD_ITERATORS_STR = "Child iterators";
        private final String RESULT_PROCESSORS_PROFILE_STR = "Result processors profile";

        @Override
        public Map<String, Object> build(Object data) {
            List list = (List)SafeEncoder.encodeObject(data);
            HashMap<String, Object> profileMap = new HashMap<String, Object>(list.size(), 1.0f);
            for (Object listObject : list) {
                Object attributeValue;
                List attributeList = (List)listObject;
                String attributeName = (String)attributeList.get(0);
                if (attributeList.size() == 2) {
                    Object value = attributeList.get(1);
                    attributeValue = attributeName.equals("Iterators profile") ? this.parseIterators(value) : (attributeName.endsWith(" time") ? DoublePrecision.parseEncodedFloatingPointNumber(value) : value);
                } else if (attributeList.size() > 2) {
                    if (attributeName.equals("Result processors profile")) {
                        ArrayList<Map<String, Object>> resultProcessorsProfileList = new ArrayList<Map<String, Object>>(attributeList.size() - 1);
                        for (int i = 1; i < attributeList.size(); ++i) {
                            resultProcessorsProfileList.add(this.parseResultProcessors(attributeList.get(i)));
                        }
                        attributeValue = resultProcessorsProfileList;
                    } else {
                        attributeValue = attributeList.subList(1, attributeList.size());
                    }
                } else {
                    attributeValue = null;
                }
                profileMap.put(attributeName, attributeValue);
            }
            return profileMap;
        }

        private Map<String, Object> parseResultProcessors(Object data) {
            List list = (List)data;
            HashMap<String, Object> map = new HashMap<String, Object>(list.size() / 2, 1.0f);
            for (int i = 0; i < list.size(); i += 2) {
                String key = (String)list.get(i);
                Object value = list.get(i + 1);
                if (key.equals("Time")) {
                    value = DoublePrecision.parseEncodedFloatingPointNumber(value);
                }
                map.put(key, value);
            }
            return map;
        }

        private Object parseIterators(Object data) {
            HashMap<String, Object> iteratorsProfile;
            if (!(data instanceof List)) {
                return data;
            }
            List iteratorsAttributeList = (List)data;
            int childIteratorsIndex = iteratorsAttributeList.indexOf("Child iterators");
            if (childIteratorsIndex < 0) {
                childIteratorsIndex = iteratorsAttributeList.indexOf("Child iterator");
            }
            if (childIteratorsIndex < 0) {
                childIteratorsIndex = iteratorsAttributeList.size();
                iteratorsProfile = new HashMap(childIteratorsIndex / 2, 1.0f);
            } else {
                iteratorsProfile = new HashMap<String, Object>(1 + childIteratorsIndex / 2, 1.0f);
            }
            for (int i = 0; i < childIteratorsIndex; i += 2) {
                String key = (String)iteratorsAttributeList.get(i);
                Object value = iteratorsAttributeList.get(i + 1);
                if (key.equals("Time")) {
                    value = DoublePrecision.parseEncodedFloatingPointNumber(value);
                }
                iteratorsProfile.put(key, value);
            }
            if (childIteratorsIndex + 1 < iteratorsAttributeList.size()) {
                ArrayList<Object> childIteratorsList = new ArrayList<Object>(iteratorsAttributeList.size() - childIteratorsIndex - 1);
                for (int i = childIteratorsIndex + 1; i < iteratorsAttributeList.size(); ++i) {
                    childIteratorsList.add(this.parseIterators(iteratorsAttributeList.get(i)));
                }
                iteratorsProfile.put("Child iterators", childIteratorsList);
            }
            return iteratorsProfile;
        }
    };
    public static final Builder<Map<String, List<String>>> SEARCH_SYNONYM_GROUPS = new Builder<Map<String, List<String>>>(){

        @Override
        public Map<String, List<String>> build(Object data) {
            List list = (List)data;
            if (list.isEmpty()) {
                return Collections.emptyMap();
            }
            if (list.get(0) instanceof KeyValue) {
                return ((List)data).stream().collect(Collectors.toMap(kv -> BuilderFactory.STRING.build(kv.getKey()), kv -> BuilderFactory.STRING_LIST.build(kv.getValue())));
            }
            HashMap<String, List<String>> dump = new HashMap<String, List<String>>(list.size() / 2, 1.0f);
            for (int i = 0; i < list.size(); i += 2) {
                dump.put(BuilderFactory.STRING.build(list.get(i)), BuilderFactory.STRING_LIST.build(list.get(i + 1)));
            }
            return dump;
        }
    };
    public static final Builder<Map<String, Map<String, Double>>> SEARCH_SPELLCHECK_RESPONSE = new Builder<Map<String, Map<String, Double>>>(){
        private static final String TERM = "TERM";
        private static final String RESULTS = "results";

        @Override
        public Map<String, Map<String, Double>> build(Object data) {
            List rawDataList = (List)data;
            if (rawDataList.isEmpty()) {
                return Collections.emptyMap();
            }
            if (rawDataList.get(0) instanceof KeyValue) {
                KeyValue rawData = (KeyValue)rawDataList.get(0);
                String header = BuilderFactory.STRING.build(rawData.getKey());
                if (!RESULTS.equals(header)) {
                    throw new IllegalStateException("Unrecognized header: " + header);
                }
                return ((List)rawData.getValue()).stream().collect(Collectors.toMap(rawTerm -> BuilderFactory.STRING.build(rawTerm.getKey()), rawTerm -> ((List)rawTerm.getValue()).stream().collect(Collectors.toMap(entry -> BuilderFactory.STRING.build(((KeyValue)entry.get(0)).getKey()), entry -> BuilderFactory.DOUBLE.build(((KeyValue)entry.get(0)).getValue()))), (x, y) -> x, LinkedHashMap::new));
            }
            LinkedHashMap<String, Map<String, Double>> returnTerms = new LinkedHashMap<String, Map<String, Double>>(rawDataList.size());
            for (Object rawData : rawDataList) {
                List rawElements = (List)rawData;
                String header = BuilderFactory.STRING.build(rawElements.get(0));
                if (!TERM.equals(header)) {
                    throw new IllegalStateException("Unrecognized header: " + header);
                }
                String term = BuilderFactory.STRING.build(rawElements.get(1));
                List list = (List)rawElements.get(2);
                LinkedHashMap entries = new LinkedHashMap(list.size());
                list.forEach(entry -> entries.put(BuilderFactory.STRING.build(entry.get(1)), BuilderFactory.DOUBLE.build(entry.get(0))));
                returnTerms.put(term, entries);
            }
            return returnTerms;
        }
    };

    private SearchBuilderFactory() {
        throw new InstantiationError("Must not instantiate this class");
    }
}

