/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.ui.LookupNode;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

final class EnvironmentNode
extends AbstractNode {
    static final long serialVersionUID = 4782447107972624693L;
    private String filter;
    private static final String EN_ICON_BASE = "org/netbeans/core/resources/";
    private static HashMap<String, Node> types = new HashMap(11);
    private static final Object lock = new Object();
    public static final String TYPE_ROOTS = "roots";
    public static final String TYPE_ENVIRONMENT = "environment";
    public static final String TYPE_SESSION = "session";

    private EnvironmentNode(String string, Children children) {
        super(children);
        this.filter = string;
        EnvironmentNode.decorateNode(string, this);
    }

    public static Node find(final String string) {
        Node node = (Node)Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<Node>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Node run() {
                Object object = lock;
                synchronized (object) {
                    Object object2 = (Node)types.get(string);
                    if (object2 == null) {
                        DataFolder dataFolder = null;
                        if (EnvironmentNode.TYPE_ENVIRONMENT.equals(string)) {
                            NbPlaces.getDefault();
                            dataFolder = NbPlaces.findSessionFolder("UI/Runtime");
                        } else if (EnvironmentNode.TYPE_ROOTS.equals(string)) {
                            NbPlaces.getDefault();
                            dataFolder = NbPlaces.findSessionFolder("UI/Roots");
                        } else {
                            assert (EnvironmentNode.TYPE_SESSION.equals(string)) : string;
                            NbPlaces.getDefault();
                            dataFolder = NbPlaces.findSessionFolder("UI/Services");
                        }
                        object2 = new PersistentLookupNode(string, dataFolder);
                        if (EnvironmentNode.TYPE_ENVIRONMENT.equals(string)) {
                            object2 = new NoDragAndDropNode((Node)object2);
                        }
                        types.put(string, object2);
                    }
                    return object2;
                }
            }
        });
        if (node != null) {
            return node;
        }
        throw new IllegalStateException();
    }

    private static void decorateNode(String string, AbstractNode abstractNode) {
        String string2 = "CTL_" + string + "_name";
        String string3 = EN_ICON_BASE + string.toLowerCase() + ".gif";
        abstractNode.setDisplayName(NbBundle.getMessage(EnvironmentNode.class, (String)string2));
        abstractNode.setIconBaseWithExtension(string3);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EnvironmentNode.class);
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    public Node.Handle getHandle() {
        return new EnvironmentHandle(this.filter);
    }

    private static class NoDragAndDropNode
    extends FilterNode {
        public NoDragAndDropNode(Node node) {
            super(node);
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            return null;
        }
    }

    static final class EnvironmentHandle
    implements Node.Handle {
        static final long serialVersionUID = -850350968366553370L;
        private String filter;

        public EnvironmentHandle(String string) {
            this.filter = string;
        }

        public Node getNode() {
            String string = this.filter;
            if (string == null) {
                string = EnvironmentNode.TYPE_ENVIRONMENT;
            }
            return EnvironmentNode.find(string);
        }
    }

    private static final class PersistentLookupNode
    extends LookupNode
    implements PropertyChangeListener {
        private String filter;

        public PersistentLookupNode(String string, DataFolder dataFolder) {
            super(dataFolder);
            this.filter = string;
            if (EnvironmentNode.TYPE_ROOTS.equals(string)) {
                dataFolder.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataFolder));
            }
        }

        public Node.Handle getHandle() {
            return new EnvironmentHandle(this.filter);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("children".equals(propertyChangeEvent.getPropertyName())) {
                NbPlaces.getDefault().fireChange();
            }
        }
    }
}

