/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.flowframework.model.WorkflowState;

public class GetWorkflowStateResponse
extends ActionResponse
implements ToXContentObject {
    private final WorkflowState workflowState;
    private final boolean allStatus;

    public GetWorkflowStateResponse(StreamInput in) throws IOException {
        super(in);
        this.workflowState = new WorkflowState(in);
        this.allStatus = in.readBoolean();
    }

    public GetWorkflowStateResponse(WorkflowState workflowState, boolean allStatus) {
        this.allStatus = allStatus;
        this.workflowState = allStatus ? workflowState : WorkflowState.builder().workflowId(workflowState.getWorkflowId()).error(workflowState.getError()).state(workflowState.getState()).resourcesCreated(workflowState.resourcesCreated()).build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.workflowState.writeTo(out);
        out.writeBoolean(this.allStatus);
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        return this.workflowState.toXContent(xContentBuilder, params);
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public boolean isAllStatus() {
        return this.allStatus;
    }
}

