/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.flowframework.common.DefaultUseCases;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.transport.CreateWorkflowAction;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;

public class RestCreateWorkflowAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestCreateWorkflowAction.class);
    private static final String CREATE_WORKFLOW_ACTION = "create_workflow_action";
    private FlowFrameworkSettings flowFrameworkSettings;

    public RestCreateWorkflowAction(FlowFrameworkSettings flowFrameworkSettings) {
        this.flowFrameworkSettings = flowFrameworkSettings;
    }

    public String getName() {
        return CREATE_WORKFLOW_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s", "/_plugins/_flow_framework/workflow")), new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_flow_framework/workflow", "workflow_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map<String, String> params;
        String workflowId = request.param("workflow_id");
        String[] validation = request.paramAsStringArray("validation", new String[]{"all"});
        boolean provision = request.paramAsBoolean("provision", false);
        boolean updateFields = request.paramAsBoolean("update_fields", false);
        String useCase = request.param("use_case");
        Map<String, String> map = provision ? request.params().keySet().stream().filter(k -> !request.consumedParams().contains(k)).collect(Collectors.toMap(Function.identity(), arg_0 -> ((RestRequest)request).param(arg_0))) : (params = request.params().entrySet().stream().filter(e -> !request.consumedParams().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        if (!this.flowFrameworkSettings.isFlowFrameworkEnabled()) {
            FlowFrameworkException ffe = new FlowFrameworkException("This API is disabled. To enable it, set [" + FlowFrameworkSettings.FLOW_FRAMEWORK_ENABLED.getKey() + "] to true.", RestStatus.FORBIDDEN);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ffe.getRestStatus(), ffe.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
        if (!provision && !params.isEmpty()) {
            params.keySet().stream().forEach(arg_0 -> ((RestRequest)request).param(arg_0));
            request.content();
            FlowFrameworkException ffe = new FlowFrameworkException("Only the parameters " + String.valueOf(request.consumedParams()) + " are permitted unless the provision parameter is set to true.", RestStatus.BAD_REQUEST);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ffe.getRestStatus(), ffe.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
        if (provision && updateFields) {
            params.keySet().stream().forEach(arg_0 -> ((RestRequest)request).param(arg_0));
            request.content();
            FlowFrameworkException ffe = new FlowFrameworkException("You can not use both the provision and update_fields parameters in the same request.", RestStatus.BAD_REQUEST);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ffe.getRestStatus(), ffe.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
        try {
            Template template;
            Map<String, String> useCaseDefaultsMap = Collections.emptyMap();
            if (useCase != null) {
                String useCaseTemplateFileInStringFormat = ParseUtils.resourceToString("/" + DefaultUseCases.getSubstitutionReadyFileByUseCaseName(useCase));
                String defaultsFilePath = DefaultUseCases.getDefaultsFileByUseCaseName(useCase);
                useCaseDefaultsMap = ParseUtils.parseJsonFileToStringToStringMap("/" + defaultsFilePath);
                List<String> requiredParams = DefaultUseCases.getRequiredParamsByUseCaseName(useCase);
                if (!request.hasContent()) {
                    if (!requiredParams.isEmpty()) {
                        throw new FlowFrameworkException("Missing the following required parameters for use case [" + useCase + "] : " + requiredParams.toString(), RestStatus.BAD_REQUEST);
                    }
                } else {
                    try {
                        XContentParser parser = request.contentParser();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        Map<String, Object> userDefaults = ParseUtils.parseStringToObjectMap(parser);
                        Set<String> userDefaultKeys = userDefaults.keySet();
                        if (!userDefaultKeys.containsAll(requiredParams)) {
                            requiredParams.removeAll(userDefaultKeys);
                            throw new FlowFrameworkException("Missing the following required parameters for use case [" + useCase + "] : " + requiredParams.toString(), RestStatus.BAD_REQUEST);
                        }
                        for (Map.Entry<String, Object> userDefaultsEntry : userDefaults.entrySet()) {
                            String key = userDefaultsEntry.getKey();
                            String value = userDefaultsEntry.getValue().toString();
                            if (!useCaseDefaultsMap.containsKey(key)) continue;
                            useCaseDefaultsMap.put(key, value);
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof FlowFrameworkException) {
                            throw ex;
                        }
                        RestStatus status = ex instanceof IOException ? RestStatus.BAD_REQUEST : ExceptionsHelper.status((Throwable)ex);
                        String errorMessage = "failure parsing request body when a use case is given, make sure to provide a map with values that are either Strings, Arrays, or Map of Strings to Strings";
                        logger.error(errorMessage, (Throwable)ex);
                        throw new FlowFrameworkException(errorMessage, status);
                    }
                }
                useCaseTemplateFileInStringFormat = (String)ParseUtils.conditionallySubstitute(useCaseTemplateFileInStringFormat, null, useCaseDefaultsMap);
                XContentParser useCaseParser = ParseUtils.jsonToParser(useCaseTemplateFileInStringFormat);
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)useCaseParser.currentToken(), (XContentParser)useCaseParser);
                template = Template.parse(useCaseParser);
            } else {
                XContentParser parser = request.contentParser();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                template = Template.parse(parser, updateFields);
            }
            if (updateFields) {
                params = Map.of("update_fields", "true");
            }
            WorkflowRequest workflowRequest = new WorkflowRequest(workflowId, template, validation, provision || updateFields, params, useCase, useCaseDefaultsMap);
            return channel -> client.execute((ActionType)CreateWorkflowAction.INSTANCE, (ActionRequest)workflowRequest, ActionListener.wrap(response -> {
                XContentBuilder builder = response.toXContent(channel.newBuilder(), ToXContent.EMPTY_PARAMS);
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, builder));
            }, exception -> {
                try {
                    FlowFrameworkException ex = exception instanceof FlowFrameworkException ? (FlowFrameworkException)((Object)((Object)((Object)exception))) : new FlowFrameworkException("Failed to get workflow.", ExceptionsHelper.status((Throwable)exception));
                    XContentBuilder exceptionBuilder = ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), exceptionBuilder));
                }
                catch (IOException e) {
                    String errorMessage = "IOException: Failed to send back create workflow exception";
                    logger.error(errorMessage, (Throwable)e);
                    channel.sendResponse((RestResponse)new BytesRestResponse(ExceptionsHelper.status((Throwable)e), errorMessage));
                }
            }));
        }
        catch (FlowFrameworkException e2) {
            logger.error("failed to prepare rest request", (Throwable)((Object)e2));
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(e2.getRestStatus(), e2.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
        catch (Exception e3) {
            logger.error("failed to prepare rest request", (Throwable)e3);
            FlowFrameworkException ex = new FlowFrameworkException("IOException: template content invalid for specified Content-Type.", RestStatus.BAD_REQUEST);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(ex.getRestStatus(), ex.toXContent(channel.newErrorBuilder(), ToXContent.EMPTY_PARAMS)));
        }
    }
}

