/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.core.common.text.Text;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprValueFactory;
import org.opensearch.sql.opensearch.storage.OpenSearchIndex;

public class OpenSearchResponse
implements Iterable<ExprValue> {
    private final SearchHits hits;
    private final Aggregations aggregations;
    private final List<String> includes;
    private final OpenSearchExprValueFactory exprValueFactory;

    public OpenSearchResponse(SearchResponse searchResponse, OpenSearchExprValueFactory exprValueFactory, List<String> includes) {
        this.hits = searchResponse.getHits();
        this.aggregations = searchResponse.getAggregations();
        this.exprValueFactory = exprValueFactory;
        this.includes = includes;
    }

    public OpenSearchResponse(SearchHits hits, OpenSearchExprValueFactory exprValueFactory, List<String> includes) {
        this.hits = hits;
        this.aggregations = null;
        this.exprValueFactory = exprValueFactory;
        this.includes = includes;
    }

    public boolean isEmpty() {
        return this.hits.getHits() == null || this.hits.getHits().length == 0 && this.aggregations == null;
    }

    public boolean isAggregationResponse() {
        return this.aggregations != null;
    }

    @Override
    public Iterator<ExprValue> iterator() {
        if (this.isAggregationResponse()) {
            return this.handleAggregationResponse();
        }
        return Arrays.stream(this.hits.getHits()).map(hit -> {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            this.addParsedHitsToBuilder((ImmutableMap.Builder<String, ExprValue>)builder, (SearchHit)hit);
            this.addMetaDataFieldsToBuilder((ImmutableMap.Builder<String, ExprValue>)builder, (SearchHit)hit);
            this.addHighlightsToBuilder((ImmutableMap.Builder<String, ExprValue>)builder, (SearchHit)hit);
            return ExprTupleValue.fromExprValueMap((Map)builder.build());
        }).iterator();
    }

    private void addParsedHitsToBuilder(ImmutableMap.Builder<String, ExprValue> builder, SearchHit hit) {
        builder.putAll(this.exprValueFactory.construct(hit.getSourceAsString(), hit.getInnerHits() != null && !hit.getInnerHits().isEmpty()).tupleValue());
    }

    private void addHighlightsToBuilder(ImmutableMap.Builder<String, ExprValue> builder, SearchHit hit) {
        if (!hit.getHighlightFields().isEmpty()) {
            ImmutableMap.Builder hlBuilder = ImmutableMap.builder();
            for (Map.Entry es : hit.getHighlightFields().entrySet()) {
                hlBuilder.put((Object)((String)es.getKey()), (Object)ExprValueUtils.collectionValue(Arrays.stream(((HighlightField)es.getValue()).fragments()).map(Text::toString).collect(Collectors.toList())));
            }
            builder.put((Object)"_highlight", (Object)ExprTupleValue.fromExprValueMap((Map)hlBuilder.build()));
        }
    }

    private void addMetaDataFieldsToBuilder(ImmutableMap.Builder<String, ExprValue> builder, SearchHit hit) {
        List<String> metaDataFieldSet = this.includes.stream().filter(OpenSearchIndex.METADATAFIELD_TYPE_MAP::containsKey).collect(Collectors.toList());
        ExprFloatValue maxScore = Float.isNaN(this.hits.getMaxScore()) ? null : new ExprFloatValue((Number)Float.valueOf(this.hits.getMaxScore()));
        metaDataFieldSet.forEach(metaDataField -> {
            if (metaDataField.equals("_index")) {
                builder.put((Object)"_index", (Object)new ExprStringValue(hit.getIndex()));
            } else if (metaDataField.equals("_id")) {
                builder.put((Object)"_id", (Object)new ExprStringValue(hit.getId()));
            } else if (metaDataField.equals("_score")) {
                if (!Float.isNaN(hit.getScore())) {
                    builder.put((Object)"_score", (Object)new ExprFloatValue((Number)Float.valueOf(hit.getScore())));
                }
            } else if (metaDataField.equals("_maxscore")) {
                if (maxScore != null) {
                    builder.put((Object)"_maxscore", (Object)maxScore);
                }
            } else if (metaDataField.equals("_sort")) {
                builder.put((Object)"_sort", (Object)new ExprLongValue((Number)hit.getSeqNo()));
            } else {
                builder.put((Object)"_routing", (Object)new ExprStringValue(hit.getShard().toString()));
            }
        });
    }

    private Iterator<ExprValue> handleAggregationResponse() {
        return this.exprValueFactory.getParser().parse(this.aggregations).stream().map(entry -> {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry value : entry.entrySet()) {
                builder.put((Object)((String)value.getKey()), (Object)this.exprValueFactory.construct((String)value.getKey(), value.getValue(), false));
            }
            return ExprTupleValue.fromExprValueMap((Map)builder.build());
        }).iterator();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchResponse)) {
            return false;
        }
        OpenSearchResponse other = (OpenSearchResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SearchHits this$hits = this.hits;
        SearchHits other$hits = other.hits;
        if (this$hits == null ? other$hits != null : !this$hits.equals(other$hits)) {
            return false;
        }
        Aggregations this$aggregations = this.aggregations;
        Aggregations other$aggregations = other.aggregations;
        if (this$aggregations == null ? other$aggregations != null : !this$aggregations.equals(other$aggregations)) {
            return false;
        }
        List<String> this$includes = this.includes;
        List<String> other$includes = other.includes;
        return !(this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SearchHits $hits = this.hits;
        result = result * 59 + ($hits == null ? 43 : $hits.hashCode());
        Aggregations $aggregations = this.aggregations;
        result = result * 59 + ($aggregations == null ? 43 : $aggregations.hashCode());
        List<String> $includes = this.includes;
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchResponse(hits=" + String.valueOf(this.hits) + ", aggregations=" + String.valueOf(this.aggregations) + ", includes=" + String.valueOf(this.includes) + ", exprValueFactory=" + String.valueOf(this.exprValueFactory) + ")";
    }
}

