/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class SignatureBuildingComponents {
    @NotNull
    public static final SignatureBuildingComponents INSTANCE = new SignatureBuildingComponents();

    private SignatureBuildingComponents() {
    }

    @NotNull
    public final String javaLang(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"java/lang/", (Object)name);
    }

    @NotNull
    public final String javaUtil(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"java/util/", (Object)name);
    }

    @NotNull
    public final String javaFunction(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"java/util/function/", (Object)name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] constructors(String ... signatures) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        String[] $this$map$iv = signatures;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = var7_7[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "<init>(" + (String)it + ")V";
            collection.add(string);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray2;
    }

    @NotNull
    public final Set<String> inJavaLang(@NotNull String name, String ... signatures) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        String string = this.javaLang(name);
        String[] stringArray = new String[signatures.length];
        System.arraycopy(signatures, 0, stringArray, 0, signatures.length);
        return this.inClass(string, stringArray);
    }

    @NotNull
    public final Set<String> inJavaUtil(@NotNull String name, String ... signatures) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        String string = this.javaUtil(name);
        String[] stringArray = new String[signatures.length];
        System.arraycopy(signatures, 0, stringArray, 0, signatures.length);
        return this.inClass(string, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> inClass(@NotNull String internalName, String ... signatures) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Intrinsics.checkNotNullParameter((Object)signatures, (String)"signatures");
        String[] stringArray = signatures;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv;
        int n = ((void)var6_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var10_10 = item$iv = var6_6[i];
            Collection collection = destination$iv;
            boolean bl = false;
            String string = internalName + '.' + (String)it;
            collection.add(string);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final String signature(@NotNull String internalName, @NotNull String jvmDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        Intrinsics.checkNotNullParameter((Object)jvmDescriptor2, (String)"jvmDescriptor");
        return internalName + '.' + jvmDescriptor2;
    }

    @NotNull
    public final String jvmDescriptor(@NotNull String name, @NotNull List<String> parameters2, @NotNull String ret) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
        return name + '(' + CollectionsKt.joinToString$default((Iterable)parameters2, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ SignatureBuildingComponents this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SignatureBuildingComponents.access$escapeClassName(this.this$0, it);
            }
        }), (int)30, null) + ')' + this.escapeClassName(ret);
    }

    private final String escapeClassName(String internalName) {
        return internalName.length() > 1 ? 'L' + internalName + ';' : internalName;
    }

    public static final /* synthetic */ String access$escapeClassName(SignatureBuildingComponents $this, String internalName) {
        return $this.escapeClassName(internalName);
    }
}

