/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.index;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.OpenSearchWrapperException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.common.utils.IndexUtils;
import org.opensearch.ml.memory.index.ConversationMetaIndex;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;

public class InteractionsIndex {
    @Generated
    private static final Logger log = LogManager.getLogger(InteractionsIndex.class);
    private Client client;
    private ClusterService clusterService;
    private ConversationMetaIndex conversationMetaIndex;
    private final int resultsAtATime = 300;

    public void initInteractionsIndexIfAbsent(ActionListener<Boolean> listener) {
        block11: {
            if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
                log.debug("No messages index found. Adding it");
                CreateIndexRequest request = Requests.createIndexRequest((String)".plugins-ml-memory-message").mapping(ConversationalIndexConstants.INTERACTIONS_MAPPINGS, XContentType.JSON).settings(IndexUtils.INDEX_SETTINGS);
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
                    ActionListener al = ActionListener.wrap(r -> {
                        if (r.equals((Object)new CreateIndexResponse(true, true, ".plugins-ml-memory-message"))) {
                            log.info("created index [.plugins-ml-memory-message]");
                            internalListener.onResponse((Object)true);
                        } else {
                            internalListener.onResponse((Object)false);
                        }
                    }, e -> {
                        if (e instanceof ResourceAlreadyExistsException || e instanceof OpenSearchWrapperException && e.getCause() instanceof ResourceAlreadyExistsException) {
                            internalListener.onResponse((Object)true);
                        } else {
                            log.error("Failed to create index [.plugins-ml-memory-message]", (Throwable)e);
                            internalListener.onFailure(e);
                        }
                    });
                    this.client.admin().indices().create(request, al);
                }
                catch (Exception e2) {
                    if (e2 instanceof ResourceAlreadyExistsException || e2 instanceof OpenSearchWrapperException && e2.getCause() instanceof ResourceAlreadyExistsException) {
                        listener.onResponse((Object)true);
                        break block11;
                    }
                    log.error("Failed to create index [.plugins-ml-memory-message]", (Throwable)e2);
                    listener.onFailure(e2);
                }
            } else {
                listener.onResponse((Object)true);
            }
        }
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, Instant timestamp, ActionListener<String> listener, String parintid, Integer traceNumber) {
        this.initInteractionsIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(indexExists -> {
            String user;
            String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
            String string = user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
            if (indexExists.booleanValue()) {
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                    if (access.booleanValue()) {
                        IndexRequest request = Requests.indexRequest((String)".plugins-ml-memory-message").source(new Object[]{"origin", origin, "memory_id", conversationId, "input", input, "prompt_template", promptTemplate, "response", response, "additional_info", additionalInfo, "create_time", timestamp, "parent_message_id", parintid, "trace_number", traceNumber});
                        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                            ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                            ActionListener al = ActionListener.wrap(resp -> {
                                if (resp.status() == RestStatus.CREATED) {
                                    internalListener.onResponse((Object)resp.getId());
                                    log.info("Successfully created the message with id : {}", (Object)resp.getId());
                                } else {
                                    internalListener.onFailure((Exception)new IOException("Failed to create message"));
                                }
                            }, e -> internalListener.onFailure(e));
                            this.client.index(request, al);
                        }
                        catch (Exception e2) {
                            listener.onFailure(e2);
                        }
                    } else {
                        throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                }, e -> listener.onFailure(e)));
            } else {
                listener.onFailure((Exception)new IOException("no index to add memory to"));
            }
        }, e -> listener.onFailure(e)));
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, Instant timestamp, ActionListener<String> listener) {
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, timestamp, listener, null, null);
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, ActionListener<String> listener) {
        this.createInteraction(conversationId, input, promptTemplate, response, origin, additionalInfo, Instant.now(), listener, null, null);
    }

    public void getInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
            listener.onResponse(List.of());
            return;
        }
        ActionListener accessListener = ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            this.innerGetInteractions(conversationId, from, maxResults, listener);
        }, e -> listener.onFailure(e));
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
    }

    @VisibleForTesting
    void innerGetInteractions(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        SearchRequest request = Requests.searchRequest((String[])new String[]{".plugins-ml-memory-message"});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        boolQueryBuilder.mustNot((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"memory_id", (String)conversationId);
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        request.source(searchSourceBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("create_time", SortOrder.ASC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListener.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully get the messages for memory {}", (Object)conversationId);
            }, e -> {
                internalListener.onFailure(e);
                log.error("Failed to get the messages for memory {}", (Object)conversationId);
            });
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-message"}), ActionListener.wrap(r -> this.client.search(request, al), e -> internalListener.onFailure(e)));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void getTraces(String interactionId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
            listener.onResponse(List.of());
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest request = Requests.getRequest((String)".plugins-ml-memory-message").id(interactionId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(interactionId)) {
                    throw new ResourceNotFoundException("Message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                String conversationId = interaction.getConversationId();
                ActionListener accessListener = ActionListener.wrap(access -> {
                    if (!access.booleanValue()) {
                        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                        throw new OpenSearchStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                    this.innerGetTraces(interactionId, from, maxResults, listener);
                }, e -> listener.onFailure(e));
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-message"}), ActionListener.wrap(refreshResponse -> this.client.get(request, ActionListener.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh message index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @VisibleForTesting
    void innerGetTraces(String interactionId, int from, int maxResults, ActionListener<List<Interaction>> listener) {
        SearchRequest request = Requests.searchRequest((String[])new String[]{".plugins-ml-memory-message"});
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ExistsQueryBuilder existsQueryBuilder = QueryBuilders.existsQuery((String)"trace_number");
        boolQueryBuilder.must((QueryBuilder)existsQueryBuilder);
        TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"parent_message_id", (String)interactionId);
        boolQueryBuilder.must((QueryBuilder)termQueryBuilder);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        request.source(searchSourceBuilder);
        request.source().from(from).size(maxResults);
        request.source().sort("trace_number", SortOrder.ASC);
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener al = ActionListener.wrap(response -> {
                LinkedList<Interaction> result = new LinkedList<Interaction>();
                for (SearchHit hit : response.getHits()) {
                    result.add(Interaction.fromSearchHit((SearchHit)hit));
                }
                internalListener.onResponse(result);
                log.info("Successfully get traces for the message {}", (Object)interactionId);
            }, e -> {
                internalListener.onFailure(e);
                log.error("Failed to get traces for the message {}", (Object)interactionId);
            });
            this.client.search(request, al);
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @VisibleForTesting
    void getAllInteractions(String conversationId, int maxResults, ActionListener<List<Interaction>> listener) {
        ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, 0, maxResults, listener, new LinkedList<Interaction>());
        this.innerGetInteractions(conversationId, 0, maxResults, al);
    }

    @VisibleForTesting
    ActionListener<List<Interaction>> nextGetListener(String conversationId, int from, int maxResults, ActionListener<List<Interaction>> mainListener, List<Interaction> result) {
        if (maxResults < 1) {
            mainListener.onFailure((Exception)new IllegalArgumentException("maxResults must be positive"));
            return null;
        }
        return ActionListener.wrap(interactions -> {
            result.addAll((Collection<Interaction>)interactions);
            if (interactions.size() < maxResults) {
                mainListener.onResponse((Object)result);
            } else {
                ActionListener<List<Interaction>> al = this.nextGetListener(conversationId, from + maxResults, maxResults, mainListener, result);
                this.innerGetInteractions(conversationId, from + maxResults, maxResults, al);
            }
        }, e -> mainListener.onFailure(e));
    }

    public void deleteConversation(String conversationId, ActionListener<Boolean> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
            listener.onResponse((Object)true);
            return;
        }
        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            ActionListener searchListener = ActionListener.wrap(interactions -> {
                if (interactions.size() == 0) {
                    internalListener.onResponse((Object)true);
                    return;
                }
                BulkRequest request = Requests.bulkRequest();
                for (Interaction interaction : interactions) {
                    DeleteRequest delRequest = Requests.deleteRequest((String)".plugins-ml-memory-message").id(interaction.getId());
                    request.add(delRequest);
                }
                this.client.bulk(request, ActionListener.wrap(bulkResponse -> internalListener.onResponse((Object)(!bulkResponse.hasFailures() ? 1 : 0)), e -> internalListener.onFailure(e)));
            }, e -> internalListener.onFailure(e));
            ActionListener accessListener = ActionListener.wrap(access -> {
                if (!access.booleanValue()) {
                    throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
                }
                this.getAllInteractions(conversationId, 300, (ActionListener<List<Interaction>>)searchListener);
            }, e -> listener.onFailure(e));
            this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
        }
        catch (Exception e2) {
            log.error("Failure while deleting messages associated with memory id=" + conversationId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public void searchInteractions(String conversationId, SearchRequest request, ActionListener<SearchResponse> listener) {
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)ActionListener.wrap(access -> {
            if (access.booleanValue()) {
                try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                    ActionListener internalListener = ActionListener.runBefore((ActionListener)listener, () -> threadContext.restore());
                    request.indices(new String[]{".plugins-ml-memory-message"});
                    QueryBuilder originalQuery = request.source().query();
                    BoolQueryBuilder newQuery = new BoolQueryBuilder();
                    newQuery.must(originalQuery);
                    newQuery.must((QueryBuilder)new TermQueryBuilder("memory_id", conversationId));
                    request.source().query((QueryBuilder)newQuery);
                    this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-message"}), ActionListener.wrap(refreshResponse -> this.client.search(request, internalListener), e -> {
                        log.error("Failed to refresh messages index during search messages ", (Throwable)e);
                        internalListener.onFailure(e);
                    }));
                }
                catch (Exception e2) {
                    listener.onFailure(e2);
                }
            } else {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                throw new OpenSearchStatusException("User [" + user + "] does not have access to memory " + conversationId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
        }, e -> listener.onFailure(e)));
    }

    public void getInteraction(String interactionId, ActionListener<Interaction> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot get message since the messages index does not exist", ".plugins-ml-memory-message"));
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest request = Requests.getRequest((String)".plugins-ml-memory-message").id(interactionId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(interactionId)) {
                    throw new ResourceNotFoundException("Message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                this.checkInteractionPermission(interactionId, interaction, (ActionListener<Interaction>)internalListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-message"}), ActionListener.wrap(refreshResponse -> this.client.get(request, ActionListener.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh message index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    public void updateInteraction(String interactionId, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        if (!this.clusterService.state().metadata().hasIndex(".plugins-ml-memory-message")) {
            listener.onFailure((Exception)new IndexNotFoundException("cannot update message since the message index does not exist", ".plugins-ml-memory-message"));
            return;
        }
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            GetRequest request = Requests.getRequest((String)".plugins-ml-memory-message").id(interactionId);
            ActionListener al = ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists() || !getResponse.getId().equals(interactionId)) {
                    throw new ResourceNotFoundException("message [" + interactionId + "] not found", new Object[0]);
                }
                Interaction interaction = Interaction.fromMap((String)interactionId, (Map)getResponse.getSourceAsMap());
                String conversationId = interaction.getConversationId();
                ActionListener accessListener = ActionListener.wrap(access -> {
                    if (!access.booleanValue()) {
                        String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                        String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                        throw new OpenSearchStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
                    }
                    this.innerUpdateInteraction(updateRequest, (ActionListener<UpdateResponse>)internalListener);
                }, e -> listener.onFailure(e));
                this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
            }, e -> internalListener.onFailure(e));
            this.client.admin().indices().refresh(Requests.refreshRequest((String[])new String[]{".plugins-ml-memory-message"}), ActionListener.wrap(refreshResponse -> this.client.get(request, ActionListener.runBefore((ActionListener)al, () -> threadContext.restore())), e -> {
                log.error("Failed to refresh messages index during get message ", (Throwable)e);
                internalListener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    private void innerUpdateInteraction(UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener internalListener = ActionListener.runBefore(listener, () -> threadContext.restore());
            this.client.update(updateRequest, internalListener);
        }
        catch (Exception e) {
            log.error("Failed to update message. Details {}:", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void checkInteractionPermission(String interactionId, Interaction interaction, ActionListener<Interaction> internalListener) {
        String conversationId = interaction.getConversationId();
        ActionListener accessListener = ActionListener.wrap(access -> {
            if (!access.booleanValue()) {
                String userstr = (String)this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info");
                String user = User.parse((String)userstr) == null ? "BAD_USER" : User.parse((String)userstr).getName();
                throw new OpenSearchStatusException("User [" + user + "] does not have access to message " + interactionId, RestStatus.UNAUTHORIZED, new Object[0]);
            }
            internalListener.onResponse((Object)interaction);
            log.info("Successfully get the message : {}", (Object)interactionId);
        }, e -> internalListener.onFailure(e));
        this.conversationMetaIndex.checkAccess(conversationId, (ActionListener<Boolean>)accessListener);
    }

    @Generated
    public InteractionsIndex(Client client, ClusterService clusterService, ConversationMetaIndex conversationMetaIndex) {
        this.client = client;
        this.clusterService = clusterService;
        this.conversationMetaIndex = conversationMetaIndex;
    }
}

