/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.RestRequest;

public class CreateInteractionRequest
extends ActionRequest {
    private String conversationId;
    private String input;
    private String promptTemplate;
    private String response;
    private String origin;
    private Map<String, String> additionalInfo;
    private String parentIid;
    private Integer traceNumber;

    public CreateInteractionRequest(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
    }

    public CreateInteractionRequest(StreamInput in) throws IOException {
        super(in);
        this.conversationId = in.readString();
        this.input = in.readString();
        this.promptTemplate = in.readString();
        this.response = in.readString();
        this.origin = in.readOptionalString();
        if (in.readBoolean()) {
            this.additionalInfo = in.readMap(s -> s.readString(), s -> s.readString());
        }
        this.parentIid = in.readOptionalString();
        this.traceNumber = in.readOptionalInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.conversationId);
        out.writeString(this.input);
        out.writeString(this.promptTemplate);
        out.writeString(this.response);
        out.writeOptionalString(this.origin);
        if (this.additionalInfo != null) {
            out.writeBoolean(true);
            out.writeMap(this.additionalInfo, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.parentIid);
        out.writeOptionalInt(this.traceNumber);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.conversationId == null) {
            exception = ValidateActions.addValidationError((String)"Interaction MUST belong to a conversation ID", exception);
        }
        return exception;
    }

    public static CreateInteractionRequest fromRestRequest(RestRequest request) throws IOException {
        String cid = request.param("memory_id");
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        String input = null;
        String prompt = null;
        String response = null;
        String origin = null;
        Map<String, String> addinf = new HashMap<String, String>();
        String parintid = null;
        Integer tracenum = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block18: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "input": {
                    input = parser.text();
                    continue block18;
                }
                case "prompt_template": {
                    prompt = parser.text();
                    continue block18;
                }
                case "response": {
                    response = parser.text();
                    continue block18;
                }
                case "origin": {
                    origin = parser.text();
                    continue block18;
                }
                case "additional_info": {
                    addinf = parser.mapStrings();
                    continue block18;
                }
                case "parent_message_id": {
                    parintid = parser.text();
                    continue block18;
                }
                case "trace_number": {
                    tracenum = parser.intValue(false);
                    continue block18;
                }
            }
            parser.skipChildren();
        }
        return new CreateInteractionRequest(cid, input, prompt, response, origin, addinf, parintid, tracenum);
    }

    @Generated
    public CreateInteractionRequest(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, String parentIid, Integer traceNumber) {
        this.conversationId = conversationId;
        this.input = input;
        this.promptTemplate = promptTemplate;
        this.response = response;
        this.origin = origin;
        this.additionalInfo = additionalInfo;
        this.parentIid = parentIid;
        this.traceNumber = traceNumber;
    }

    @Generated
    public String getConversationId() {
        return this.conversationId;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getPromptTemplate() {
        return this.promptTemplate;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public String getOrigin() {
        return this.origin;
    }

    @Generated
    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Generated
    public String getParentIid() {
        return this.parentIid;
    }

    @Generated
    public Integer getTraceNumber() {
        return this.traceNumber;
    }
}

