/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression;

import com.google.common.base.Strings;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.env.Environment;

public class NamedExpression
implements Expression {
    private final String name;
    private final Expression delegated;
    private String alias;

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        return this.delegated.valueOf(valueEnv);
    }

    @Override
    public ExprType type() {
        return this.delegated.type();
    }

    public String getNameOrAlias() {
        return Strings.isNullOrEmpty((String)this.alias) ? this.name : this.alias;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitNamed(this, context);
    }

    public String toString() {
        return this.getNameOrAlias();
    }

    @Generated
    public NamedExpression(String name, Expression delegated, String alias) {
        this.name = name;
        this.delegated = delegated;
        this.alias = alias;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedExpression)) {
            return false;
        }
        NamedExpression other = (NamedExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Expression this$delegated = this.getDelegated();
        Expression other$delegated = other.getDelegated();
        if (this$delegated == null ? other$delegated != null : !this$delegated.equals(other$delegated)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NamedExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Expression $delegated = this.getDelegated();
        result = result * 59 + ($delegated == null ? 43 : $delegated.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Expression getDelegated() {
        return this.delegated;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public NamedExpression(String name, Expression delegated) {
        this.name = name;
        this.delegated = delegated;
    }
}

