/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;

public class Aggregation
extends UnresolvedPlan {
    private List<UnresolvedExpression> aggExprList;
    private List<UnresolvedExpression> sortExprList;
    private List<UnresolvedExpression> groupExprList;
    private UnresolvedExpression span;
    private List<Argument> argExprList;
    private UnresolvedPlan child;

    public Aggregation(List<UnresolvedExpression> aggExprList, List<UnresolvedExpression> sortExprList, List<UnresolvedExpression> groupExprList) {
        this(aggExprList, sortExprList, groupExprList, null, Collections.emptyList());
    }

    public Aggregation(List<UnresolvedExpression> aggExprList, List<UnresolvedExpression> sortExprList, List<UnresolvedExpression> groupExprList, UnresolvedExpression span, List<Argument> argExprList) {
        this.aggExprList = aggExprList;
        this.sortExprList = sortExprList;
        this.groupExprList = groupExprList;
        this.span = span;
        this.argExprList = argExprList;
    }

    public boolean hasArgument() {
        return !this.aggExprList.isEmpty();
    }

    @Override
    public Aggregation attach(UnresolvedPlan child) {
        this.child = child;
        return this;
    }

    public List<UnresolvedPlan> getChild() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitAggregation(this, context);
    }

    @Generated
    public List<UnresolvedExpression> getAggExprList() {
        return this.aggExprList;
    }

    @Generated
    public List<UnresolvedExpression> getSortExprList() {
        return this.sortExprList;
    }

    @Generated
    public List<UnresolvedExpression> getGroupExprList() {
        return this.groupExprList;
    }

    @Generated
    public UnresolvedExpression getSpan() {
        return this.span;
    }

    @Generated
    public List<Argument> getArgExprList() {
        return this.argExprList;
    }

    @Generated
    public void setAggExprList(List<UnresolvedExpression> aggExprList) {
        this.aggExprList = aggExprList;
    }

    @Generated
    public void setSortExprList(List<UnresolvedExpression> sortExprList) {
        this.sortExprList = sortExprList;
    }

    @Generated
    public void setGroupExprList(List<UnresolvedExpression> groupExprList) {
        this.groupExprList = groupExprList;
    }

    @Generated
    public void setSpan(UnresolvedExpression span) {
        this.span = span;
    }

    @Generated
    public void setArgExprList(List<Argument> argExprList) {
        this.argExprList = argExprList;
    }

    @Generated
    public void setChild(UnresolvedPlan child) {
        this.child = child;
    }

    @Override
    @Generated
    public String toString() {
        return "Aggregation(aggExprList=" + String.valueOf(this.getAggExprList()) + ", sortExprList=" + String.valueOf(this.getSortExprList()) + ", groupExprList=" + String.valueOf(this.getGroupExprList()) + ", span=" + String.valueOf(this.getSpan()) + ", argExprList=" + String.valueOf(this.getArgExprList()) + ", child=" + String.valueOf(this.getChild()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Aggregation)) {
            return false;
        }
        Aggregation other = (Aggregation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedExpression> this$aggExprList = this.getAggExprList();
        List<UnresolvedExpression> other$aggExprList = other.getAggExprList();
        if (this$aggExprList == null ? other$aggExprList != null : !((Object)this$aggExprList).equals(other$aggExprList)) {
            return false;
        }
        List<UnresolvedExpression> this$sortExprList = this.getSortExprList();
        List<UnresolvedExpression> other$sortExprList = other.getSortExprList();
        if (this$sortExprList == null ? other$sortExprList != null : !((Object)this$sortExprList).equals(other$sortExprList)) {
            return false;
        }
        List<UnresolvedExpression> this$groupExprList = this.getGroupExprList();
        List<UnresolvedExpression> other$groupExprList = other.getGroupExprList();
        if (this$groupExprList == null ? other$groupExprList != null : !((Object)this$groupExprList).equals(other$groupExprList)) {
            return false;
        }
        UnresolvedExpression this$span = this.getSpan();
        UnresolvedExpression other$span = other.getSpan();
        if (this$span == null ? other$span != null : !((Object)this$span).equals(other$span)) {
            return false;
        }
        List<Argument> this$argExprList = this.getArgExprList();
        List<Argument> other$argExprList = other.getArgExprList();
        if (this$argExprList == null ? other$argExprList != null : !((Object)this$argExprList).equals(other$argExprList)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        return !(this$child == null ? other$child != null : !((Object)this$child).equals(other$child));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Aggregation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedExpression> $aggExprList = this.getAggExprList();
        result = result * 59 + ($aggExprList == null ? 43 : ((Object)$aggExprList).hashCode());
        List<UnresolvedExpression> $sortExprList = this.getSortExprList();
        result = result * 59 + ($sortExprList == null ? 43 : ((Object)$sortExprList).hashCode());
        List<UnresolvedExpression> $groupExprList = this.getGroupExprList();
        result = result * 59 + ($groupExprList == null ? 43 : ((Object)$groupExprList).hashCode());
        UnresolvedExpression $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : ((Object)$span).hashCode());
        List<Argument> $argExprList = this.getArgExprList();
        result = result * 59 + ($argExprList == null ? 43 : ((Object)$argExprList).hashCode());
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        return result;
    }
}

