/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.io;

import com.oracle.labs.mlrg.olcut.config.ConfigurationData;
import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.SerializedObject;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoader;
import com.oracle.labs.mlrg.olcut.config.io.ConfigLoaderException;
import com.oracle.labs.mlrg.olcut.config.io.FileFormatFactory;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class URLLoader {
    private final Map<String, ConfigLoader> loaderMap = new HashMap<String, ConfigLoader>();
    private final Queue<URL> urlQueue;
    private final Map<String, FileFormatFactory> formatFactoryMap;
    private final Map<String, ConfigurationData> rpdMap = new HashMap<String, ConfigurationData>();
    private final Map<String, ConfigurationData> existingRPD;
    private final Map<String, SerializedObject> serializedObjects = new HashMap<String, SerializedObject>();
    private final GlobalProperties globalProperties = new GlobalProperties();

    public URLLoader(Queue<URL> urlQueue, Map<String, FileFormatFactory> formatFactoryMap) {
        this(urlQueue, formatFactoryMap, null);
    }

    public URLLoader(Queue<URL> urlQueue, Map<String, FileFormatFactory> formatFactoryMap, Map<String, ConfigurationData> existingRPD) {
        this.urlQueue = urlQueue;
        this.formatFactoryMap = formatFactoryMap;
        this.existingRPD = existingRPD;
    }

    public void load() throws ConfigLoaderException {
        while (!this.urlQueue.isEmpty()) {
            URL curURL = this.urlQueue.poll();
            String filename = curURL.getFile();
            int i = filename.lastIndexOf(46);
            String extension = i > 0 ? filename.substring(i + 1).toLowerCase() : "";
            ConfigLoader loader = this.getLoader(extension);
            loader.load(curURL);
        }
    }

    public void addURL(URL url) {
        this.urlQueue.add(url);
    }

    public Map<String, ConfigurationData> getPropertyMap() {
        return this.rpdMap;
    }

    public Map<String, SerializedObject> getSerializedObjects() {
        return this.serializedObjects;
    }

    public GlobalProperties getGlobalProperties() {
        return this.globalProperties;
    }

    private ConfigLoader getLoader(String extension) throws ConfigLoaderException {
        ConfigLoader loader = this.loaderMap.get(extension);
        if (loader == null) {
            FileFormatFactory factory = this.formatFactoryMap.get(extension);
            if (factory != null) {
                loader = factory.getLoader(this, this.rpdMap, this.existingRPD, this.serializedObjects, this.globalProperties);
                this.loaderMap.put(extension, loader);
            } else {
                throw new PropertyException(extension, "Failed to load a handler for '" + extension + "' files.");
            }
        }
        return loader;
    }
}

