/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.opensearch.index.codec.fuzzy.FuzzyFilterPostingsFormat;
import org.opensearch.index.codec.fuzzy.FuzzySetFactory;
import org.opensearch.index.codec.fuzzy.FuzzySetParameters;
import org.opensearch.index.mapper.CompletionFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene99Codec {
    private final Logger logger;
    private final MapperService mapperService;
    private final DocValuesFormat dvFormat = new Lucene90DocValuesFormat();
    private final FuzzySetFactory fuzzySetFactory;
    private PostingsFormat docIdPostingsFormat;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene99Codec.Mode compressionMode, MapperService mapperService, Logger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
        this.fuzzySetFactory = new FuzzySetFactory(Map.of("_id", new FuzzySetParameters(() -> mapperService.getIndexSettings().getDocIdFuzzySetFalsePositiveProbability())));
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType fieldType = this.mapperService.fieldType(field);
        if (fieldType == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", (Object)field);
        } else {
            if (fieldType instanceof CompletionFieldMapper.CompletionFieldType) {
                return CompletionFieldMapper.CompletionFieldType.postingsFormat();
            }
            if ("_id".equals(field) && this.mapperService.getIndexSettings().isEnableFuzzySetForDocId()) {
                if (this.docIdPostingsFormat == null) {
                    this.docIdPostingsFormat = new FuzzyFilterPostingsFormat(super.getPostingsFormatForField(field), this.fuzzySetFactory);
                }
                return this.docIdPostingsFormat;
            }
        }
        return super.getPostingsFormatForField(field);
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.dvFormat;
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName((String)"Lucene99").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene99");
        }
    }
}

