/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.cache.query;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class QueryCacheStats
implements Writeable,
ToXContentFragment {
    private long ramBytesUsed;
    private long hitCount;
    private long missCount;
    private long cacheCount;
    private long cacheSize;

    public QueryCacheStats() {
    }

    public QueryCacheStats(StreamInput in) throws IOException {
        this.ramBytesUsed = in.readLong();
        this.hitCount = in.readLong();
        this.missCount = in.readLong();
        this.cacheCount = in.readLong();
        this.cacheSize = in.readLong();
    }

    public QueryCacheStats(long ramBytesUsed, long hitCount, long missCount, long cacheCount, long cacheSize) {
        this.ramBytesUsed = ramBytesUsed;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.cacheCount = cacheCount;
        this.cacheSize = cacheSize;
    }

    public void add(QueryCacheStats stats) {
        this.ramBytesUsed += stats.ramBytesUsed;
        this.hitCount += stats.hitCount;
        this.missCount += stats.missCount;
        this.cacheCount += stats.cacheCount;
        this.cacheSize += stats.cacheSize;
    }

    public long getMemorySizeInBytes() {
        return this.ramBytesUsed;
    }

    public ByteSizeValue getMemorySize() {
        return new ByteSizeValue(this.ramBytesUsed);
    }

    public long getTotalCount() {
        return this.hitCount + this.missCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getCacheCount() {
        return this.cacheCount;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public long getEvictions() {
        return this.cacheCount - this.cacheSize;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.ramBytesUsed);
        out.writeLong(this.hitCount);
        out.writeLong(this.missCount);
        out.writeLong(this.cacheCount);
        out.writeLong(this.cacheSize);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("query_cache");
        builder.humanReadableField("memory_size_in_bytes", "memory_size", (Object)this.getMemorySize());
        builder.field("total_count", this.getTotalCount());
        builder.field("hit_count", this.getHitCount());
        builder.field("miss_count", this.getMissCount());
        builder.field("cache_size", this.getCacheSize());
        builder.field("cache_count", this.getCacheCount());
        builder.field("evictions", this.getEvictions());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String QUERY_CACHE = "query_cache";
        static final String MEMORY_SIZE = "memory_size";
        static final String MEMORY_SIZE_IN_BYTES = "memory_size_in_bytes";
        static final String TOTAL_COUNT = "total_count";
        static final String HIT_COUNT = "hit_count";
        static final String MISS_COUNT = "miss_count";
        static final String CACHE_SIZE = "cache_size";
        static final String CACHE_COUNT = "cache_count";
        static final String EVICTIONS = "evictions";

        Fields() {
        }
    }
}

