/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.opensearch.common.remote.RemoteWritableEntityStore;
import org.opensearch.core.action.ActionListener;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateBlobStore<T, U extends AbstractRemoteWritableBlobEntity<T>>
implements RemoteWritableEntityStore<T, U> {
    private final BlobStoreTransferService transferService;
    private final BlobStoreRepository blobStoreRepository;
    private final String clusterName;
    private final ExecutorService executorService;

    public RemoteClusterStateBlobStore(BlobStoreTransferService blobStoreTransferService, BlobStoreRepository blobStoreRepository, String clusterName, ThreadPool threadPool, String executor) {
        this.transferService = blobStoreTransferService;
        this.blobStoreRepository = blobStoreRepository;
        this.clusterName = clusterName;
        this.executorService = threadPool.executor(executor);
    }

    @Override
    public void writeAsync(U entity, ActionListener<Void> listener) {
        try (InputStream inputStream = entity.serialize();){
            BlobPath blobPath = this.getBlobPathForUpload((AbstractRemoteWritableBlobEntity<T>)entity);
            ((AbstractRemoteWritableBlobEntity)entity).setFullBlobName(blobPath);
            this.transferService.uploadBlob(inputStream, this.getBlobPathForUpload((AbstractRemoteWritableBlobEntity<T>)entity), ((AbstractRemoteWritableBlobEntity)entity).getBlobFileName(), WritePriority.URGENT, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public T read(U entity) throws IOException {
        assert (((AbstractRemoteWritableBlobEntity)entity).getFullBlobName() != null);
        try (InputStream inputStream = this.transferService.downloadBlob(this.getBlobPathForDownload((AbstractRemoteWritableBlobEntity<T>)entity), ((AbstractRemoteWritableBlobEntity)entity).getBlobFileName());){
            Object t = entity.deserialize(inputStream);
            return t;
        }
    }

    @Override
    public void readAsync(U entity, ActionListener<T> listener) {
        this.executorService.execute(() -> {
            try {
                listener.onResponse(this.read(entity));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public BlobPath getBlobPathPrefix(String clusterUUID) {
        return this.blobStoreRepository.basePath().add(RemoteClusterStateUtils.encodeString(this.getClusterName())).add("cluster-state").add(clusterUUID);
    }

    public BlobPath getBlobPathForUpload(AbstractRemoteWritableBlobEntity<T> obj) {
        BlobPath blobPath = this.getBlobPathPrefix(obj.clusterUUID());
        for (String token : obj.getBlobPathParameters().getPathTokens()) {
            blobPath = blobPath.add(token);
        }
        return blobPath;
    }

    public BlobPath getBlobPathForDownload(AbstractRemoteWritableBlobEntity<T> obj) {
        String[] pathTokens = obj.getBlobPathTokens();
        BlobPath blobPath = new BlobPath();
        if (pathTokens == null || pathTokens.length < 1) {
            return blobPath;
        }
        for (int i = 0; i < pathTokens.length - 1; ++i) {
            blobPath = blobPath.add(pathTokens[i]);
        }
        return blobPath;
    }
}

