/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.logging.Loggers;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.AsyncShardFetchCache;
import org.opensearch.gateway.ShardBatchResponseFactory;
import org.opensearch.indices.store.ShardAttributes;
import reactor.util.annotation.NonNull;

public abstract class AsyncShardBatchFetch<T extends BaseNodeResponse, V>
extends AsyncShardFetch<T> {
    AsyncShardBatchFetch(Logger logger, String type, Map<ShardId, ShardAttributes> shardAttributesMap, AsyncShardFetch.Lister<? extends BaseNodesResponse<T>, T> action, String batchId, Class<V> clazz, V emptyShardResponse, Predicate<V> emptyShardResponsePredicate, ShardBatchResponseFactory<T, V> responseFactory) {
        super(logger, type, shardAttributesMap, action, batchId, new ShardBatchCache<T, V>(logger, type, shardAttributesMap, "BatchID=[" + batchId + "]", clazz, emptyShardResponse, emptyShardResponsePredicate, responseFactory));
    }

    public synchronized void clearShard(ShardId shardId) {
        this.shardAttributesMap.remove(shardId);
        this.cache.deleteShard(shardId);
    }

    static class ShardBatchCache<T extends BaseNodeResponse, V>
    extends AsyncShardFetchCache<T> {
        private final Map<String, NodeEntry<V>> cache;
        private final Map<ShardId, Integer> shardIdToArray;
        private final int batchSize;
        private final Class<V> shardResponseClass;
        private final ShardBatchResponseFactory<T, V> responseFactory;
        private final V emptyResponse;
        private final Predicate<V> emptyShardResponsePredicate;
        private final Logger logger;

        public ShardBatchCache(Logger logger, String type, Map<ShardId, ShardAttributes> shardAttributesMap, String logKey, Class<V> clazz, V emptyResponse, Predicate<V> emptyShardResponsePredicate, ShardBatchResponseFactory<T, V> responseFactory) {
            super(Loggers.getLogger(logger, "_" + logKey), type);
            this.batchSize = shardAttributesMap.size();
            this.emptyShardResponsePredicate = emptyShardResponsePredicate;
            this.cache = new HashMap<String, NodeEntry<V>>();
            this.shardIdToArray = new HashMap<ShardId, Integer>();
            this.fillShardIdKeys(shardAttributesMap.keySet());
            this.shardResponseClass = clazz;
            this.emptyResponse = emptyResponse;
            this.logger = logger;
            this.responseFactory = responseFactory;
        }

        @Override
        @NonNull
        public Map<String, ? extends AsyncShardFetchCache.BaseNodeEntry> getCache() {
            return this.cache;
        }

        @Override
        public void deleteShard(ShardId shardId) {
            if (this.shardIdToArray.containsKey(shardId)) {
                Integer shardIdIndex = this.shardIdToArray.remove(shardId);
                for (String nodeId : this.cache.keySet()) {
                    this.cache.get(nodeId).clearShard(shardIdIndex);
                }
            }
        }

        @Override
        public void initData(DiscoveryNode node) {
            this.cache.put(node.getId(), new NodeEntry<V>(node.getId(), this.shardResponseClass, this.batchSize, this.emptyShardResponsePredicate));
        }

        @Override
        public void putData(DiscoveryNode node, T response) {
            NodeEntry<V> nodeEntry = this.cache.get(node.getId());
            Map<ShardId, V> batchResponse = this.responseFactory.getShardBatchData(response);
            nodeEntry.doneFetching(batchResponse, this.shardIdToArray);
        }

        @Override
        public T getData(DiscoveryNode node) {
            return this.responseFactory.getNewResponse(node, this.getBatchData(this.cache.get(node.getId())));
        }

        private HashMap<ShardId, V> getBatchData(NodeEntry<V> nodeEntry) {
            V[] nodeShardEntries = nodeEntry.getData();
            boolean[] emptyResponses = nodeEntry.getEmptyShardResponse();
            HashMap<ShardId, V> shardData = new HashMap<ShardId, V>();
            for (Map.Entry<ShardId, Integer> shardIdEntry : this.shardIdToArray.entrySet()) {
                ShardId shardId = shardIdEntry.getKey();
                Integer arrIndex = shardIdEntry.getValue();
                if (emptyResponses[arrIndex]) {
                    shardData.put(shardId, this.emptyResponse);
                    continue;
                }
                if (nodeShardEntries[arrIndex] == null) continue;
                shardData.put(shardId, nodeShardEntries[arrIndex]);
            }
            return shardData;
        }

        private void fillShardIdKeys(Set<ShardId> shardIds) {
            int shardIdIndex = 0;
            for (ShardId shardId : shardIds) {
                this.shardIdToArray.putIfAbsent(shardId, shardIdIndex++);
            }
        }

        static class NodeEntry<V>
        extends AsyncShardFetchCache.BaseNodeEntry {
            private final V[] shardData;
            private final boolean[] emptyShardResponse;
            private final Predicate<V> emptyShardResponsePredicate;

            NodeEntry(String nodeId, Class<V> clazz, int batchSize, Predicate<V> emptyShardResponsePredicate) {
                super(nodeId);
                this.shardData = (Object[])Array.newInstance(clazz, batchSize);
                this.emptyShardResponse = new boolean[batchSize];
                this.emptyShardResponsePredicate = emptyShardResponsePredicate;
            }

            void doneFetching(Map<ShardId, V> shardDataFromNode, Map<ShardId, Integer> shardIdKey) {
                this.fillShardData(shardDataFromNode, shardIdKey);
                super.doneFetching();
            }

            void clearShard(Integer shardIdIndex) {
                this.shardData[shardIdIndex.intValue()] = null;
                this.emptyShardResponse[shardIdIndex.intValue()] = false;
            }

            V[] getData() {
                return this.shardData;
            }

            boolean[] getEmptyShardResponse() {
                return this.emptyShardResponse;
            }

            private void fillShardData(Map<ShardId, V> shardDataFromNode, Map<ShardId, Integer> shardIdKey) {
                for (Map.Entry<ShardId, V> shardData : shardDataFromNode.entrySet()) {
                    if (shardData.getValue() == null) continue;
                    ShardId shardId = shardData.getKey();
                    if (this.emptyShardResponsePredicate.test(shardData.getValue())) {
                        this.emptyShardResponse[shardIdKey.get((Object)shardId).intValue()] = true;
                        this.shardData[shardIdKey.get((Object)shardId).intValue()] = null;
                        continue;
                    }
                    this.shardData[shardIdKey.get((Object)shardId).intValue()] = shardData.getValue();
                }
            }
        }
    }
}

