/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.tiering;

import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.indices.tiering.HotToWarmTieringAction;
import org.opensearch.action.admin.indices.tiering.TieringIndexRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

@ExperimentalApi
public class RestWarmTieringAction
extends BaseRestHandler {
    private static final String TARGET_TIER = "warm";

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_tier/warm"));
    }

    @Override
    public String getName() {
        return "warm_tiering_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        TieringIndexRequest tieringIndexRequest = new TieringIndexRequest(TARGET_TIER, Strings.splitStringByCommaToArray((String)request.param("index")));
        tieringIndexRequest.timeout(request.paramAsTime("timeout", tieringIndexRequest.timeout()));
        tieringIndexRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", tieringIndexRequest.clusterManagerNodeTimeout()));
        tieringIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, tieringIndexRequest.indicesOptions()));
        tieringIndexRequest.waitForCompletion(request.paramAsBoolean("wait_for_completion", tieringIndexRequest.waitForCompletion()));
        return channel -> client.admin().cluster().execute(HotToWarmTieringAction.INSTANCE, tieringIndexRequest, new RestToXContentListener((RestChannel)channel));
    }
}

