/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.transport.controller.MLControllerGetAction;
import org.opensearch.ml.common.transport.controller.MLControllerGetRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLGetControllerAction
extends BaseRestHandler {
    private static final String ML_GET_CONTROLLER_ACTION = "ml_get_controller_action";

    public String getName() {
        return ML_GET_CONTROLLER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/controllers/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLControllerGetRequest controllerGetRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLControllerGetAction.INSTANCE, (ActionRequest)controllerGetRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLControllerGetRequest getRequest(RestRequest request) throws IOException {
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        boolean returnContent = RestActionUtils.returnContent(request);
        return new MLControllerGetRequest(modelId, returnContent);
    }
}

