/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModelGroup;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetRequest;
import org.opensearch.ml.common.transport.model_group.MLModelGroupGetResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetModelGroupTransportAction
extends HandledTransportAction<ActionRequest, MLModelGroupGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetModelGroupTransportAction.class);
    private Client client;
    private NamedXContentRegistry xContentRegistry;
    private ClusterService clusterService;
    private ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public GetModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/model_groups/get", transportService, actionFilters, MLModelGroupGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLModelGroupGetResponse> actionListener) {
        MLModelGroupGetRequest mlModelGroupGetRequest = MLModelGroupGetRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = mlModelGroupGetRequest.getModelGroupId();
        GetRequest getRequest = new GetRequest(".plugins-ml-model-group").id(modelGroupId);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> context.restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLModelGroup mlModelGroup = MLModelGroup.parse((XContentParser)parser);
                        this.modelAccessControlHelper.validateModelGroupAccess(user, modelGroupId, this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                            if (!access.booleanValue()) {
                                wrappedListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model group", RestStatus.FORBIDDEN, new Object[0]));
                            } else {
                                wrappedListener.onResponse((Object)MLModelGroupGetResponse.builder().mlModelGroup(mlModelGroup).build());
                            }
                        }, e -> {
                            log.error("Failed to validate access for Model Group " + modelGroupId, (Throwable)e);
                            wrappedListener.onFailure(e);
                        }));
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse ml model group" + r.getId(), (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model group with the provided model group id: " + modelGroupId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Fail to find model group index"));
                } else {
                    log.error("Failed to get ML model group" + modelGroupId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Failed to get ML model group " + modelGroupId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }
}

