/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.search.internal.SearchContext;

public class HybridQueryUtil {
    public static boolean isHybridQuery(Query query, SearchContext searchContext) {
        if (query instanceof HybridQuery) {
            return true;
        }
        if (HybridQueryUtil.isWrappedHybridQuery(query)) {
            return HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext) || HybridQueryUtil.hasAliasFilter(query, searchContext);
        }
        return false;
    }

    public static boolean hasNestedFieldOrNestedDocs(Query query, SearchContext searchContext) {
        return searchContext.mapperService().hasNested() && new NestedHelper(searchContext.mapperService()).mightMatchNestedDocs(query);
    }

    private static boolean isWrappedHybridQuery(Query query) {
        return query instanceof BooleanQuery && ((BooleanQuery)query).clauses().stream().anyMatch(clauseQuery -> clauseQuery.getQuery() instanceof HybridQuery);
    }

    public static boolean hasAliasFilter(Query query, SearchContext searchContext) {
        return Objects.nonNull(searchContext.aliasFilter());
    }

    @Generated
    private HybridQueryUtil() {
    }
}

