/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.math.la;

import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ToDoubleBiFunction;
import org.tribuo.math.la.Matrix;
import org.tribuo.math.la.Tensor;
import org.tribuo.math.la.VectorTuple;
import org.tribuo.math.util.VectorNormalizer;

public interface SGDVector
extends Tensor,
Iterable<VectorTuple> {
    public void foreachIndexedInPlace(ToDoubleBiFunction<Integer, Double> var1);

    @Override
    public SGDVector copy();

    public int size();

    public int numActiveElements();

    public SGDVector scale(double var1);

    public void add(int var1, double var2);

    public SGDVector add(SGDVector var1);

    public SGDVector subtract(SGDVector var1);

    public double dot(SGDVector var1);

    public Matrix outer(SGDVector var1);

    public double sum();

    @Override
    public double twoNorm();

    public double oneNorm();

    public double get(int var1);

    public void set(int var1, double var2);

    public int indexOfMax();

    public double maxValue();

    public double minValue();

    public void normalize(VectorNormalizer var1);

    public double reduce(double var1, DoubleUnaryOperator var3, DoubleBinaryOperator var4);

    default public double l2Distance(SGDVector other) {
        return this.euclideanDistance(other);
    }

    public double euclideanDistance(SGDVector var1);

    public double l1Distance(SGDVector var1);

    default public double cosineDistance(SGDVector other) {
        return 1.0 - this.cosineSimilarity(other);
    }

    default public double cosineSimilarity(SGDVector other) {
        double numerator = this.dot(other);
        double output = 0.0;
        if (numerator != 0.0) {
            output = numerator / (this.twoNorm() * other.twoNorm());
        }
        return output;
    }

    default public double variance() {
        double mean = this.sum() / (double)this.size();
        return this.variance(mean);
    }

    public double variance(double var1);

    public double[] toArray();
}

