/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.StepListener;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.SecurityAnalyticsPlugin;
import org.opensearch.securityanalytics.threatIntel.action.ThreatIntelIndicesResponse;
import org.opensearch.securityanalytics.threatIntel.common.StashedThreadContext;
import org.opensearch.securityanalytics.threatIntel.model.TIFJobParameter;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class TIFJobParameterService {
    private static final Logger log = LogManager.getLogger(TIFJobParameterService.class);
    private final Client client;
    private final ClusterService clusterService;
    private final ClusterSettings clusterSettings;

    public TIFJobParameterService(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.clusterSettings = clusterService.getClusterSettings();
    }

    public void createJobIndexIfNotExists(final StepListener<Void> stepListener) {
        if (this.clusterService.state().metadata().hasIndex(".opensearch-sap--job")) {
            stepListener.onResponse(null);
            return;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(".opensearch-sap--job").mapping(this.getIndexMapping()).settings(SecurityAnalyticsPlugin.TIF_JOB_INDEX_SETTING);
        StashedThreadContext.run(this.client, () -> this.client.admin().indices().create(createIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse createIndexResponse) {
                stepListener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    log.info("index[{}] already exist", (Object)".opensearch-sap--job");
                    stepListener.onResponse(null);
                    return;
                }
                log.error("Failed to create security analytics job index", (Throwable)e);
                stepListener.onFailure(e);
            }
        }));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getIndexMapping() {
        try (InputStream is = TIFJobParameterService.class.getResourceAsStream("/mappings/threat_intel_job_mapping.json");){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                string = reader.lines().map(String::trim).collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            log.error("Runtime exception", (Throwable)e);
            throw new SecurityAnalyticsException("Runtime exception", RestStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    public void updateJobSchedulerParameter(final TIFJobParameter jobSchedulerParameter, final ActionListener<ThreatIntelIndicesResponse> listener) {
        jobSchedulerParameter.setLastUpdateTime(Instant.now());
        StashedThreadContext.run(this.client, () -> {
            try {
                ((IndexRequestBuilder)this.client.prepareIndex(".opensearch-sap--job").setId(jobSchedulerParameter.getName()).setOpType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(jobSchedulerParameter.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).execute((ActionListener)new ActionListener<IndexResponse>(){

                    public void onResponse(IndexResponse indexResponse) {
                        if (indexResponse.status().getStatus() >= 200 && indexResponse.status().getStatus() < 300) {
                            listener.onResponse((Object)new ThreatIntelIndicesResponse(true, jobSchedulerParameter.getIndices()));
                        } else {
                            listener.onFailure((Exception)new OpenSearchStatusException("update of job scheduler parameter failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        }
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
            catch (IOException e) {
                log.error("failed to update job scheduler param for tif job", (Throwable)e);
                listener.onFailure((Exception)e);
            }
        });
    }

    public void getJobParameter(String name, ActionListener<TIFJobParameter> listener) {
        GetRequest request = new GetRequest(".opensearch-sap--job", name);
        StashedThreadContext.run(this.client, () -> this.client.get(request, ActionListener.wrap(response -> {
            if (!response.isExists()) {
                log.error("TIF job[{}] does not exist in an index[{}]", (Object)name, (Object)".opensearch-sap--job");
                listener.onFailure((Exception)new ResourceNotFoundException("name", new Object[0]));
            }
            XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef());
            listener.onResponse((Object)((TIFJobParameter)TIFJobParameter.PARSER.parse(parser, null)));
        }, e -> {
            log.error("Failed to fetch tif job document " + name, (Throwable)e);
            listener.onFailure(e);
        })));
    }

    public void saveTIFJobParameter(TIFJobParameter tifJobParameter, ActionListener<IndexResponse> listener) {
        tifJobParameter.setLastUpdateTime(Instant.now());
        StashedThreadContext.run(this.client, () -> {
            try {
                ((IndexRequestBuilder)this.client.prepareIndex(".opensearch-sap--job").setId(tifJobParameter.getName()).setOpType(DocWriteRequest.OpType.CREATE).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).setSource(tifJobParameter.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).execute(listener);
            }
            catch (IOException e) {
                throw new SecurityAnalyticsException("Exception saving the threat intel feed job parameter in index", RestStatus.INTERNAL_SERVER_ERROR, e);
            }
        });
    }
}

