/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.jobscheduler;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.extensions.AcknowledgedResponse;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.jobscheduler.spi.utils.LockService;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigManagementService;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigService;
import org.opensearch.threadpool.ThreadPool;

public class TIFSourceConfigRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(TIFSourceConfigRunner.class);
    private static TIFSourceConfigRunner INSTANCE;
    private ClusterService clusterService;
    private TIFLockService lockService;
    private boolean initialized;
    private ThreadPool threadPool;
    private SATIFSourceConfigManagementService saTifSourceConfigManagementService;
    private SATIFSourceConfigService saTifSourceConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TIFSourceConfigRunner getJobRunnerInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<TIFSourceConfigRunner> clazz = TIFSourceConfigRunner.class;
        synchronized (TIFSourceConfigRunner.class) {
            if (INSTANCE != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
            INSTANCE = new TIFSourceConfigRunner();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private TIFSourceConfigRunner() {
    }

    public void initialize(ClusterService clusterService, TIFLockService threatIntelLockService, ThreadPool threadPool, SATIFSourceConfigManagementService saTifSourceConfigManagementService, SATIFSourceConfigService saTifSourceConfigService) {
        this.clusterService = clusterService;
        this.lockService = threatIntelLockService;
        this.threadPool = threadPool;
        this.initialized = true;
        this.saTifSourceConfigManagementService = saTifSourceConfigManagementService;
        this.saTifSourceConfigService = saTifSourceConfigService;
    }

    public void runJob(ScheduledJobParameter jobParameter, JobExecutionContext context) {
        if (!this.initialized) {
            throw new AssertionError((Object)"This instance is not initialized");
        }
        if (!(jobParameter instanceof SATIFSourceConfig)) {
            log.error("Illegal state exception: job parameter is not instance of TIF Source Config");
            throw new IllegalStateException("job parameter is not instance of TIF Source Config, type: " + jobParameter.getClass().getCanonicalName());
        }
        if (this.clusterService == null) {
            throw new IllegalStateException("ClusterService is not initialized.");
        }
        if (this.threadPool == null) {
            throw new IllegalStateException("ThreadPool is not initialized.");
        }
        LockService lockService = context.getLockService();
        this.threadPool.generic().submit(this.retrieveLockAndUpdateConfig((SATIFSourceConfig)jobParameter));
    }

    protected Runnable retrieveLockAndUpdateConfig(SATIFSourceConfig saTifSourceConfig) {
        log.info("Update job started for a TIF Source Config [{}]", (Object)saTifSourceConfig.getId());
        return () -> this.lockService.acquireLock(saTifSourceConfig.getId(), 300L, (ActionListener<LockModel>)ActionListener.wrap(lock -> this.updateSourceConfigAndIOCs(saTifSourceConfig, this.lockService.getRenewLockRunnable(new AtomicReference<LockModel>((LockModel)lock)), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> this.lockService.releaseLock((LockModel)lock), e -> {
            log.error("Failed to update threat intel source config " + saTifSourceConfig.getName(), (Throwable)e);
            this.lockService.releaseLock((LockModel)lock);
        })), e -> log.error("Failed to update. Another processor is holding a lock for job parameter[{}]", (Object)saTifSourceConfig.getName())));
    }

    protected void updateSourceConfigAndIOCs(SATIFSourceConfig SaTifSourceConfig, Runnable renewLock, ActionListener<AcknowledgedResponse> listener) {
        this.saTifSourceConfigManagementService.refreshTIFSourceConfig(SaTifSourceConfig.getId(), null, (ActionListener<SATIFSourceConfigDto>)ActionListener.wrap(r -> {
            log.info("Successfully updated source config and IOCs for threat intel source config [{}]", (Object)SaTifSourceConfig.getId());
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, e -> {
            log.error("Failed to update source config and IOCs for threat intel source config [{}]", (Object)SaTifSourceConfig.getId());
            listener.onFailure(e);
        }));
    }
}

