/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.util;

import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.KNN80Codec.KNN80BinaryDocValues;
import org.opensearch.knn.index.codec.transfer.VectorTransfer;
import org.opensearch.knn.index.codec.util.SerializationMode;

public class KNNCodecUtil {
    public static final int FLOAT_BYTE_SIZE = 4;
    public static final int JAVA_REFERENCE_SIZE = 4;
    public static final int JAVA_ARRAY_HEADER_SIZE = 12;
    public static final int JAVA_ROUNDING_NUMBER = 8;

    public static Pair getPair(BinaryDocValues values, VectorTransfer vectorTransfer) throws IOException {
        ArrayList<Integer> docIdList = new ArrayList<Integer>();
        SerializationMode serializationMode = SerializationMode.COLLECTION_OF_FLOATS;
        vectorTransfer.init(KNNCodecUtil.getTotalLiveDocsCount(values));
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            BytesRef bytesref = values.binaryValue();
            serializationMode = vectorTransfer.getSerializationMode(bytesref);
            vectorTransfer.transfer(bytesref);
            docIdList.add(doc);
            doc = values.nextDoc();
        }
        vectorTransfer.close();
        return new Pair(docIdList.stream().mapToInt(Integer::intValue).toArray(), vectorTransfer.getVectorAddress(), vectorTransfer.getDimension(), serializationMode);
    }

    public static long calculateArraySize(int numVectors, int vectorLength, SerializationMode serializationMode) {
        if (serializationMode == SerializationMode.ARRAY) {
            int vectorsSize;
            int vectorSize = vectorLength * 4 + 12;
            if (vectorSize % 8 != 0) {
                vectorSize += vectorSize % 8;
            }
            if ((vectorsSize = numVectors * (vectorSize + 4) + 12) % 8 != 0) {
                vectorsSize += vectorsSize % 8;
            }
            return vectorsSize;
        }
        if (serializationMode == SerializationMode.COLLECTION_OF_FLOATS) {
            int vectorsSize;
            int vectorSize = vectorLength * 4;
            if (vectorSize % 8 != 0) {
                vectorSize += vectorSize % 8;
            }
            if ((vectorsSize = numVectors * (vectorSize + 4)) % 8 != 0) {
                vectorsSize += vectorsSize % 8;
            }
            return vectorsSize;
        }
        if (serializationMode == SerializationMode.COLLECTIONS_OF_BYTES) {
            int vectorsSize;
            int vectorSize = vectorLength;
            if (vectorSize % 8 != 0) {
                vectorSize += vectorSize % 8;
            }
            if ((vectorsSize = numVectors * (vectorSize + 4)) % 8 != 0) {
                vectorsSize += vectorsSize % 8;
            }
            return vectorsSize;
        }
        throw new IllegalStateException("Unreachable code");
    }

    public static String buildEngineFileName(String segmentName, String latestBuildVersion, String fieldName, String extension) {
        return String.format("%s%s%s", KNNCodecUtil.buildEngineFilePrefix(segmentName), latestBuildVersion, KNNCodecUtil.buildEngineFileSuffix(fieldName, extension));
    }

    public static String buildEngineFilePrefix(String segmentName) {
        return String.format("%s_", segmentName);
    }

    public static String buildEngineFileSuffix(String fieldName, String extension) {
        return String.format("_%s%s", fieldName, extension);
    }

    private static long getTotalLiveDocsCount(BinaryDocValues binaryDocValues) {
        long totalLiveDocs = binaryDocValues instanceof KNN80BinaryDocValues ? ((KNN80BinaryDocValues)binaryDocValues).getTotalLiveDocs() : binaryDocValues.cost();
        return totalLiveDocs;
    }

    public static final class Pair {
        public int[] docs;
        private long vectorAddress;
        private int dimension;
        public SerializationMode serializationMode;

        @Generated
        public Pair(int[] docs, long vectorAddress, int dimension, SerializationMode serializationMode) {
            this.docs = docs;
            this.vectorAddress = vectorAddress;
            this.dimension = dimension;
            this.serializationMode = serializationMode;
        }

        @Generated
        public long getVectorAddress() {
            return this.vectorAddress;
        }

        @Generated
        public void setVectorAddress(long vectorAddress) {
            this.vectorAddress = vectorAddress;
        }

        @Generated
        public int getDimension() {
            return this.dimension;
        }

        @Generated
        public void setDimension(int dimension) {
            this.dimension = dimension;
        }
    }
}

