/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporterFactory;
import org.opensearch.plugin.insights.core.service.TopQueriesService;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCategorizer;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.plugin.insights.settings.QueryCategorizationSettings;
import org.opensearch.plugin.insights.settings.QueryInsightsSettings;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class QueryInsightsService
extends AbstractLifecycleComponent {
    private static final Logger logger = LogManager.getLogger(QueryInsightsService.class);
    private final ThreadPool threadPool;
    private final Map<MetricType, TopQueriesService> topQueriesServices;
    private final Map<MetricType, Boolean> enableCollect = new HashMap<MetricType, Boolean>();
    private final LinkedBlockingQueue<SearchQueryRecord> queryRecordsQueue = new LinkedBlockingQueue(1000);
    protected volatile Scheduler.Cancellable scheduledFuture;
    final QueryInsightsExporterFactory queryInsightsExporterFactory;
    private volatile boolean searchQueryMetricsEnabled;
    private SearchQueryCategorizer searchQueryCategorizer;

    @Inject
    public QueryInsightsService(ClusterSettings clusterSettings, ThreadPool threadPool, Client client, MetricsRegistry metricsRegistry) {
        this.threadPool = threadPool;
        this.queryInsightsExporterFactory = new QueryInsightsExporterFactory(client);
        this.topQueriesServices = new HashMap<MetricType, TopQueriesService>();
        for (MetricType metricType : MetricType.allMetricTypes()) {
            this.enableCollect.put(metricType, false);
            this.topQueriesServices.put(metricType, new TopQueriesService(metricType, threadPool, this.queryInsightsExporterFactory));
        }
        for (MetricType type : MetricType.allMetricTypes()) {
            clusterSettings.addSettingsUpdateConsumer(QueryInsightsSettings.getExporterSettings(type), settings -> this.setExporter(type, (Settings)settings), settings -> this.validateExporterConfig(type, (Settings)settings));
        }
        this.searchQueryMetricsEnabled = (Boolean)clusterSettings.get(QueryCategorizationSettings.SEARCH_QUERY_METRICS_ENABLED_SETTING);
        this.searchQueryCategorizer = SearchQueryCategorizer.getInstance(metricsRegistry);
        clusterSettings.addSettingsUpdateConsumer(QueryCategorizationSettings.SEARCH_QUERY_METRICS_ENABLED_SETTING, this::setSearchQueryMetricsEnabled);
    }

    public boolean addRecord(SearchQueryRecord record) {
        boolean shouldAdd = this.searchQueryMetricsEnabled;
        if (!shouldAdd) {
            for (Map.Entry<MetricType, TopQueriesService> entry : this.topQueriesServices.entrySet()) {
                List<SearchQueryRecord> currentSnapshot;
                if (!this.enableCollect.get(entry.getKey()).booleanValue() || (currentSnapshot = entry.getValue().getTopQueriesCurrentSnapshot()).size() >= entry.getValue().getTopNSize() && SearchQueryRecord.compare(record, currentSnapshot.get(0), entry.getKey()) <= 0) continue;
                shouldAdd = true;
                break;
            }
        }
        if (shouldAdd) {
            return this.queryRecordsQueue.offer(record);
        }
        return false;
    }

    public void drainRecords() {
        ArrayList<SearchQueryRecord> records = new ArrayList<SearchQueryRecord>();
        this.queryRecordsQueue.drainTo(records);
        records.sort(Comparator.comparingLong(SearchQueryRecord::getTimestamp));
        for (MetricType metricType : MetricType.allMetricTypes()) {
            if (!this.enableCollect.get(metricType).booleanValue()) continue;
            this.topQueriesServices.get(metricType).consumeRecords(records);
        }
        if (this.searchQueryMetricsEnabled) {
            try {
                this.searchQueryCategorizer.consumeRecords(records);
            }
            catch (Exception e) {
                logger.error("Error while trying to categorize the queries.", (Throwable)e);
            }
        }
    }

    public TopQueriesService getTopQueriesService(MetricType metricType) {
        return this.topQueriesServices.get(metricType);
    }

    public void enableCollection(MetricType metricType, boolean enable) {
        this.enableCollect.put(metricType, enable);
        this.topQueriesServices.get(metricType).setEnabled(enable);
    }

    public boolean isCollectionEnabled(MetricType metricType) {
        return this.enableCollect.get(metricType);
    }

    public boolean isAnyFeatureEnabled() {
        return this.isTopNFeatureEnabled() || this.isSearchQueryMetricsFeatureEnabled();
    }

    public boolean isTopNFeatureEnabled() {
        for (MetricType t : MetricType.allMetricTypes()) {
            if (!this.isCollectionEnabled(t)) continue;
            return true;
        }
        return false;
    }

    public boolean isSearchQueryMetricsFeatureEnabled() {
        return this.searchQueryMetricsEnabled;
    }

    public void checkAndStopQueryInsights() {
        if (!this.isAnyFeatureEnabled()) {
            this.stop();
        }
    }

    public void checkAndRestartQueryInsights() {
        if (this.isAnyFeatureEnabled()) {
            this.stop();
            this.start();
        }
    }

    public void validateWindowSize(MetricType type, TimeValue windowSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).validateWindowSize(windowSize);
        }
    }

    public void setWindowSize(MetricType type, TimeValue windowSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).setWindowSize(windowSize);
        }
    }

    public void validateTopNSize(MetricType type, int topNSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).validateTopNSize(topNSize);
        }
    }

    public void setTopNSize(MetricType type, int topNSize) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).setTopNSize(topNSize);
        }
    }

    public void setExporter(MetricType type, Settings settings) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).setExporter(settings);
        }
    }

    public void setSearchQueryMetricsEnabled(boolean searchQueryMetricsEnabled) {
        boolean oldSearchQueryMetricsEnabled = this.isSearchQueryMetricsFeatureEnabled();
        this.searchQueryMetricsEnabled = searchQueryMetricsEnabled;
        if (searchQueryMetricsEnabled) {
            if (!oldSearchQueryMetricsEnabled) {
                this.checkAndRestartQueryInsights();
            }
        } else if (oldSearchQueryMetricsEnabled) {
            this.checkAndStopQueryInsights();
        }
    }

    public SearchQueryCategorizer getSearchQueryCategorizer() {
        return this.searchQueryCategorizer;
    }

    public void validateExporterConfig(MetricType type, Settings settings) {
        if (this.topQueriesServices.containsKey(type)) {
            this.topQueriesServices.get(type).validateExporterConfig(settings);
        }
    }

    protected void doStart() {
        if (this.isAnyFeatureEnabled()) {
            this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(this::drainRecords, QueryInsightsSettings.QUERY_RECORD_QUEUE_DRAIN_INTERVAL, "query_insights_executor");
        }
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() throws IOException {
        for (TopQueriesService topQueriesService : this.topQueriesServices.values()) {
            topQueriesService.close();
        }
        this.queryInsightsExporterFactory.closeAllExporters();
    }
}

