---
id: 'Menu toggle'
section: components
subsection: menus
cssPrefix: pf-v5-c-menu-toggle
---import './MenuToggle.css'

## Examples

### Collapsed

```html
<button class="pf-v5-c-menu-toggle" type="button" aria-expanded="false">
  <span class="pf-v5-c-menu-toggle__text">Collapsed</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Expanded

```html
<button
  class="pf-v5-c-menu-toggle pf-m-expanded"
  type="button"
  aria-expanded="true"
>
  <span class="pf-v5-c-menu-toggle__text">Expanded</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Disabled

```html
<button
  class="pf-v5-c-menu-toggle"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__text">Disabled</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Count

```html
<button class="pf-v5-c-menu-toggle" type="button" aria-expanded="false">
  <span class="pf-v5-c-menu-toggle__text">Count</span>
  <span class="pf-v5-c-menu-toggle__count">
    <span class="pf-v5-c-badge pf-m-unread">4 selected</span>
  </span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Primary

```html
<button
  class="pf-v5-c-menu-toggle pf-m-primary"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Collapsed</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-primary"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__icon">
    <i class="fas fa-cog" aria-hidden="true"></i>
  </span>
  <span class="pf-v5-c-menu-toggle__text">Icon</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-primary pf-m-expanded"
  type="button"
  aria-expanded="true"
>
  <span class="pf-v5-c-menu-toggle__text">Expanded</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-primary"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__text">Disabled</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Secondary

```html
<button
  class="pf-v5-c-menu-toggle pf-m-secondary"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Collapsed</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-secondary"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__icon">
    <i class="fas fa-cog" aria-hidden="true"></i>
  </span>
  <span class="pf-v5-c-menu-toggle__text">Icon</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-secondary pf-m-expanded"
  type="button"
  aria-expanded="true"
>
  <span class="pf-v5-c-menu-toggle__text">Expanded</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-secondary"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__text">Disabled</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Plain

```html
<button
  class="pf-v5-c-menu-toggle pf-m-plain"
  type="button"
  aria-expanded="false"
  aria-label="Actions"
>
  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-plain pf-m-expanded"
  type="button"
  aria-expanded="true"
  aria-label="Actions"
>
  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-plain"
  type="button"
  aria-expanded="false"
  disabled
  aria-label="Actions"
>
  <i class="fas fa-ellipsis-v" aria-hidden="true"></i>
</button>

```

### Plain with text

```html
<button
  class="pf-v5-c-menu-toggle pf-m-plain pf-m-text"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__text">Disabled</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-plain pf-m-text"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Custom text</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Split button (checkbox)

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-disabled"
  id="split-button-checkbox-disabled-example"
>
  <label
    class="pf-v5-c-check pf-m-standalone"
    for="split-button-checkbox-disabled-example-input"
  >
    <input
      class="pf-v5-c-check__input"
      type="checkbox"
      aria-label="Standalone check"
      disabled
    />
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button"
  id="split-button-checkbox-example"
>
  <label
    class="pf-v5-c-check pf-m-standalone"
    for="split-button-checkbox-example-input"
  >
    <input
      class="pf-v5-c-check__input"
      type="checkbox"
      aria-label="Standalone check"
    />
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button"
  id="split-button-checkbox-expanded-example"
>
  <label
    class="pf-v5-c-check pf-m-standalone"
    for="split-button-checkbox-expanded-example-input"
  >
    <input
      class="pf-v5-c-check__input"
      type="checkbox"
      aria-label="Standalone check"
    />
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button (checkbox with toggle text)

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-disabled"
  id="split-button-checkbox-with-toggle-text-disabled-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-with-toggle-text-disabled-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" disabled />
    <label class="pf-v5-c-check__label pf-m-disabled" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-text-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button"
  id="split-button-checkbox-with-toggle-text-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-with-toggle-text-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-text-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button"
  id="split-button-checkbox-with-toggle-text-expanded-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-with-toggle-text-expanded-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-with-toggle-text-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button, primary

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-disabled pf-m-primary"
  id="split-button-checkbox-primary-disabled-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-primary-disabled-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" disabled />
    <label class="pf-v5-c-check__label pf-m-disabled" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-primary-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-primary"
  id="split-button-checkbox-primary-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-primary-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-primary-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button pf-m-primary"
  id="split-button-checkbox-primary-expanded-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-primary-expanded-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-primary-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button, secondary

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-disabled pf-m-secondary"
  id="split-button-checkbox-secondary-disabled-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-secondary-disabled-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" disabled />
    <label class="pf-v5-c-check__label pf-m-disabled" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-secondary-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-secondary"
  id="split-button-checkbox-secondary-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-secondary-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-secondary-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button pf-m-secondary"
  id="split-button-checkbox-secondary-expanded-example"
>
  <label
    class="pf-v5-c-check"
    for="split-button-checkbox-secondary-expanded-example-input"
  >
    <input class="pf-v5-c-check__input" type="checkbox" />
    <label class="pf-v5-c-check__label" for="-input">10 selected</label>
  </label>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-secondary-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button (action)

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action pf-m-disabled"
  id="split-button-checkbox-with-toggle-action-disabled-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button" disabled>Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action"
  id="split-button-checkbox-with-toggle-action-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button pf-m-action"
  id="split-button-checkbox-with-toggle-action-expanded-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-with-toggle-action-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button, primary (action)

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action pf-m-disabled pf-m-primary"
  id="split-button-checkbox-with-toggle-action-primary-disabled-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button" disabled>Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-primary-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action pf-m-primary"
  id="split-button-checkbox-with-toggle-action-primary-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-primary-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button pf-m-action pf-m-primary"
  id="split-button-checkbox-with-toggle-action-primary-expanded-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-with-toggle-action-primary-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Split button, secondary (action)

```html
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action pf-m-disabled pf-m-secondary"
  id="split-button-checkbox-with-toggle-action-secondary-disabled-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button" disabled>Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-secondary-disabled-example-toggle-button"
    aria-label="Menu toggle"
    disabled
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-split-button pf-m-action pf-m-secondary"
  id="split-button-checkbox-with-toggle-action-secondary-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="split-button-checkbox-with-toggle-action-secondary-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>
&nbsp;
<div
  class="pf-v5-c-menu-toggle pf-m-expanded pf-m-split-button pf-m-action pf-m-secondary"
  id="split-button-checkbox-with-toggle-action-secondary-expanded-example"
>
  <button class="pf-v5-c-menu-toggle__button" type="button">Action</button>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="true"
    id="split-button-checkbox-with-toggle-action-secondary-expanded-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### With icon/image and text

```html
<button
  class="pf-v5-c-menu-toggle pf-m-secondary"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__icon">
    <i class="fas fa-cog" aria-hidden="true"></i>
  </span>
  <span class="pf-v5-c-menu-toggle__text">Icon</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-secondary"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__icon">
    <i class="fas fa-cog" aria-hidden="true"></i>
  </span>
  <span class="pf-v5-c-menu-toggle__text">Icon</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### With avatar and text

```html
<button class="pf-v5-c-menu-toggle" type="button" aria-expanded="false">
  <span class="pf-v5-c-menu-toggle__icon">
    <img
      class="pf-v5-c-avatar"
      alt="Avatar image"
      src="/assets/images/img_avatar-light.svg"
    />
  </span>
  <span class="pf-v5-c-menu-toggle__text">Ned Username</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle pf-m-expanded"
  type="button"
  aria-expanded="true"
>
  <span class="pf-v5-c-menu-toggle__icon">
    <img
      class="pf-v5-c-avatar"
      alt="Avatar image"
      src="/assets/images/img_avatar-light.svg"
    />
  </span>
  <span class="pf-v5-c-menu-toggle__text">Ned Username</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

&nbsp;
<button
  class="pf-v5-c-menu-toggle"
  type="button"
  aria-expanded="false"
  disabled
>
  <span class="pf-v5-c-menu-toggle__icon">
    <img
      class="pf-v5-c-avatar"
      alt="Avatar image"
      src="/assets/images/img_avatar-light.svg"
    />
  </span>
  <span class="pf-v5-c-menu-toggle__text">Ned Username</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Full height

```html
<button
  class="pf-v5-c-menu-toggle pf-m-full-height"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Full height</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

### Typeahead

```html
<div
  class="pf-v5-c-menu-toggle pf-m-typeahead pf-m-full-width"
  id="typeahead-example"
>
  <div class="pf-v5-c-text-input-group pf-m-plain">
    <div class="pf-v5-c-text-input-group__main">
      <span class="pf-v5-c-text-input-group__text">
        <input
          class="pf-v5-c-text-input-group__text-input"
          type="text"
          value
          aria-label="Type to filter"
        />
      </span>
    </div>
    <div class="pf-v5-c-text-input-group__utilities">
      <button
        class="pf-v5-c-button pf-m-plain"
        type="button"
        aria-label="Clear input"
      >
        <i class="fas fa-times fa-fw" aria-hidden="true"></i>
      </button>
    </div>
  </div>
  <button
    class="pf-v5-c-menu-toggle__button"
    type="button"
    aria-expanded="false"
    id="typeahead-example-toggle-button"
    aria-label="Menu toggle"
  >
    <span class="pf-v5-c-menu-toggle__controls">
      <span class="pf-v5-c-menu-toggle__toggle-icon">
        <i class="fas fa-caret-down" aria-hidden="true"></i>
      </span>
    </span>
  </button>
</div>

```

### Status

```html isBeta
<button
  class="pf-v5-c-menu-toggle pf-m-success"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Success</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__status-icon">
      <i class="fas fa-check-circle" aria-hidden="true"></i>
    </span>
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

<br />
<br />

<button
  class="pf-v5-c-menu-toggle pf-m-warning"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Warning</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__status-icon">
      <i class="fas fa-exclamation-triangle" aria-hidden="true"></i>
    </span>
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

<br />
<br />

<button
  class="pf-v5-c-menu-toggle pf-m-danger"
  type="button"
  aria-expanded="false"
>
  <span class="pf-v5-c-menu-toggle__text">Danger</span>
  <span class="pf-v5-c-menu-toggle__controls">
    <span class="pf-v5-c-menu-toggle__status-icon">
      <i class="fas fa-exclamation-circle" aria-hidden="true"></i>
    </span>
    <span class="pf-v5-c-menu-toggle__toggle-icon">
      <i class="fas fa-caret-down" aria-hidden="true"></i>
    </span>
  </span>
</button>

```

## Documentation

### Accessibility

| Class | Applied to | Outcome |
| -- | -- | -- |
| `aria-expanded="true"` | `.pf-v5-c-menu-toggle`, `.pf-v5-c-menu-toggle__button` | Indicates that the menu toggle component is in the expanded state. |
| `aria-expanded="false"` | `.pf-v5-c-menu-toggle`, `.pf-v5-c-menu-toggle__button` | Indicates that the menu toggle component is in the collapsed state. |
| `aria-label="Descriptive text"` | `.pf-v5-c-menu-toggle`, `.pf-v5-c-menu-toggle.pf-m-plain` | Gives the menu toggle component an accessible label. Used whenever there is no text visible in the menu toggle. Often, plain modifiers are used when the menu toggle only contains an icon. |
| `disabled` | `.pf-v5-c-menu-toggle`, `.pf-v5-c-menu-toggle__button` | Indicates that the menu toggle component is disabled. |

### Usage

| Class | Applied | Outcome |
| -- | -- | -- |
| `.pf-v5-c-menu-toggle` | `<button>` | Initiates the menu toggle component. |
| `.pf-v5-c-menu-toggle__icon` | `<span>` | Defines the menu toggle component icon/image. |
| `.pf-v5-c-menu-toggle__text` | `<span>` | Defines the menu toggle component text. |
| `.pf-v5-c-menu-toggle__count` | `<span>` | Defines the menu toggle component count. |
| `.pf-v5-c-menu-toggle__controls` | `<span>` | Defines the menu toggle component controls. |
| `.pf-v5-c-menu-toggle__toggle-icon` | `<span>` | Defines the menu toggle component toggle/arrow icon. |
| `.pf-v5-c-menu-toggle__button` | `<button>` | Initiates the menu toggle button. |
| `.pf-m-split-button` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the split button variation. |
| `.pf-m-action` | `.pf-v5-c-menu-toggle.pf-m-split-button` | Modifies the menu toggle component for the action, split button variation. |
| `.pf-m-disabled` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the disabled variation. |
| `.pf-m-primary` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the primary variation. |
| `.pf-m-secondary` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the secondary variation. |
| `.pf-m-text` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the text variation. |
| `.pf-m-plain` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the plain variation. |
| `.pf-m-expanded` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the expanded state. |
| `.pf-m-full-height` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component to full height of parent. |
| `.pf-m-success` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the success state. |
| `.pf-m-warning` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the warning state. |
| `.pf-m-danger` | `.pf-v5-c-menu-toggle` | Modifies the menu toggle component for the danger state. |
