/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.config.ConfigSupportLevel;
import org.keycloak.config.DeprecatedMetadata;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;

public class OptionBuilder<T> {
    private static final List<String> BOOLEAN_TYPE_VALUES = List.of(Boolean.TRUE.toString(), Boolean.FALSE.toString());
    private final Class<T> type;
    private final String key;
    private OptionCategory category;
    private boolean hidden;
    private boolean build;
    private String description;
    private Optional<T> defaultValue;
    private List<String> expectedValues = List.of();
    private DeprecatedMetadata deprecatedMetadata;

    public static <A> OptionBuilder<List<A>> listOptionBuilder(String key, Class<A> type) {
        return new OptionBuilder<List<A>>(key, List.class, type);
    }

    public OptionBuilder(String key, Class<T> type) {
        this(key, type, null);
    }

    private OptionBuilder(String key, Class<T> type, Class<?> auxiliaryType) {
        this.type = type;
        if (type.isArray() || (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) && type != List.class) {
            throw new IllegalArgumentException("Non-List multi-valued options are not yet supported");
        }
        this.key = key;
        this.category = OptionCategory.GENERAL;
        this.hidden = false;
        this.build = false;
        this.description = null;
        Class<Object> expected = type;
        if (auxiliaryType != null) {
            expected = auxiliaryType;
        }
        Optional<Object> optional = this.defaultValue = Boolean.class.equals(expected) ? Optional.of(Boolean.FALSE) : Optional.empty();
        if (Boolean.class.equals(expected)) {
            this.expectedValues(BOOLEAN_TYPE_VALUES);
        }
        if (Enum.class.isAssignableFrom(expected)) {
            this.expectedValues(expected);
        }
    }

    public OptionBuilder<T> category(OptionCategory category) {
        this.category = category;
        return this;
    }

    public OptionBuilder<T> hidden() {
        this.hidden = true;
        return this;
    }

    public OptionBuilder<T> buildTime(boolean build) {
        this.build = build;
        return this;
    }

    public OptionBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder<T> defaultValue(Optional<T> defaultV) {
        this.defaultValue = defaultV;
        return this;
    }

    public OptionBuilder<T> defaultValue(T defaultV) {
        this.defaultValue = Optional.ofNullable(defaultV);
        return this;
    }

    public OptionBuilder<T> expectedValues(List<String> expected) {
        this.expectedValues = expected;
        return this;
    }

    public OptionBuilder<T> expectedValues(Class<? extends Enum> expected) {
        this.expectedValues = List.of(expected.getEnumConstants()).stream().map(Object::toString).collect(Collectors.toList());
        return this;
    }

    public OptionBuilder<T> expectedValues(T ... expected) {
        this.expectedValues = List.of(expected).stream().map(v -> v.toString()).collect(Collectors.toList());
        return this;
    }

    public OptionBuilder<T> deprecated() {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateOption(null, null);
        return this;
    }

    public OptionBuilder<T> deprecated(String note) {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateOption(note, null);
        return this;
    }

    public OptionBuilder<T> deprecated(Set<String> newOptionsKeys) {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateOption(null, newOptionsKeys);
        return this;
    }

    public OptionBuilder<T> deprecated(String note, Set<String> newOptionsKeys) {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateOption(note, newOptionsKeys);
        return this;
    }

    public OptionBuilder<T> deprecatedValues(Set<String> values, String note) {
        this.deprecatedMetadata = DeprecatedMetadata.deprecateValues(values, note);
        return this;
    }

    public Option<T> build() {
        if (this.deprecatedMetadata == null && this.category.getSupportLevel() == ConfigSupportLevel.DEPRECATED) {
            this.deprecated();
        }
        return new Option<T>(this.type, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues, this.deprecatedMetadata);
    }
}

