/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.netty.util.concurrent.FastThreadLocal;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableContext;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;

public class VertxCurrentContextFactory
implements CurrentContextFactory {
    public static final String LOCAL_KEY = "io.quarkus.vertx.cdi-current-context";

    public <T extends InjectableContext.ContextState> CurrentContext<T> create(Class<? extends Annotation> scope) {
        return new VertxCurrentContext();
    }

    private static final class VertxCurrentContext<T extends InjectableContext.ContextState>
    implements CurrentContext<T> {
        private final FastThreadLocal<T> fallback = new FastThreadLocal();

        private VertxCurrentContext() {
        }

        public T get() {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext((Context)context)) {
                return (T)((InjectableContext.ContextState)context.getLocal((Object)VertxCurrentContextFactory.LOCAL_KEY));
            }
            return (T)((InjectableContext.ContextState)this.fallback.get());
        }

        public void set(T state) {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext((Context)context)) {
                VertxContextSafetyToggle.setContextSafe(context, true);
                Object oldState = context.getLocal((Object)VertxCurrentContextFactory.LOCAL_KEY);
                if (oldState != state) {
                    context.putLocal((Object)VertxCurrentContextFactory.LOCAL_KEY, state);
                }
            } else {
                this.fallback.set(state);
            }
        }

        public void remove() {
            Context context = Vertx.currentContext();
            if (context == null || !VertxContext.isDuplicatedContext((Context)context)) {
                this.fallback.remove();
            }
        }
    }
}

