/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.overlay.OverlayTextChecker;
import com.adobe.epubcheck.overlay.SmilClock;
import com.adobe.epubcheck.vocab.AggregateVocab;
import com.adobe.epubcheck.vocab.PackageVocabs;
import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.vocab.Vocab;
import com.adobe.epubcheck.vocab.VocabUtil;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.mola.galimatias.URL;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.epubcheck.core.references.Reference;
import org.w3c.epubcheck.core.references.ResourceRegistry;
import org.w3c.epubcheck.util.url.URLUtils;

public class OverlayHandler
extends XMLHandler {
    private static Map<String, Vocab> RESERVED_VOCABS = ImmutableMap.of((Object)"", (Object)AggregateVocab.of(StructureVocab.VOCAB, StructureVocab.UNCHECKED_VOCAB));
    private static Map<String, Vocab> KNOWN_VOCAB_URIS = ImmutableMap.of();
    private static Set<String> DEFAULT_VOCAB_URIS = ImmutableSet.of((Object)"http://www.idpf.org/epub/vocab/structure/#");
    private Map<String, Vocab> vocabs = RESERVED_VOCABS;
    private Set<String> resourceRefs = new HashSet<String>();
    private final Set<PackageVocabs.ITEM_PROPERTIES> requiredProperties = EnumSet.noneOf(PackageVocabs.ITEM_PROPERTIES.class);

    public OverlayHandler(ValidationContext context) {
        super(context);
    }

    @Override
    public void startElement() {
        XMLElement e = this.currentElement();
        String name = e.getName();
        this.processGlobalAttrs();
        switch (name) {
            case "smil": {
                this.vocabs = VocabUtil.parsePrefixDeclaration(e.getAttributeNS("http://www.idpf.org/2007/ops", "prefix"), RESERVED_VOCABS, KNOWN_VOCAB_URIS, DEFAULT_VOCAB_URIS, this.report, this.location());
                break;
            }
            case "body": 
            case "seq": {
                this.processTextRef();
                break;
            }
            case "text": {
                this.processTextSrc();
                break;
            }
            case "audio": {
                this.processAudioSrc();
                this.checkTime(e.getAttribute("clipBegin"), e.getAttribute("clipEnd"));
            }
        }
    }

    private void checkTime(String clipBegin, String clipEnd) {
        SmilClock end;
        SmilClock start;
        if (clipEnd == null) {
            return;
        }
        if (clipBegin == null) {
            clipBegin = "0";
        }
        try {
            start = new SmilClock(clipBegin);
            end = new SmilClock(clipEnd);
        }
        catch (Exception ex) {
            return;
        }
        if (start.compareTo(end) == 1) {
            this.report.message(MessageId.MED_008, this.location(), new Object[0]);
        } else if (start.equals(end)) {
            this.report.message(MessageId.MED_009, this.location(), new Object[0]);
        }
    }

    private void checkType(String type) {
        Set<Property> propList = VocabUtil.parsePropertyList(type, this.vocabs, this.context, this.location());
        for (Property property : propList) {
            if (!"http://www.idpf.org/epub/vocab/structure/#".equals(property.getVocabURI())) continue;
            try {
                property.toEnum();
            }
            catch (UnsupportedOperationException ex) {
                this.report.message(MessageId.OPF_088, this.location(), property.getName());
            }
        }
    }

    private void processTextSrc() {
        URL url = this.checkURL(this.currentElement().getAttribute("src"));
        this.processContentDocumentLink(url);
    }

    private void processTextRef() {
        URL url = this.checkURL(this.currentElement().getAttributeNS("http://www.idpf.org/2007/ops", "textref"));
        this.processContentDocumentLink(url);
    }

    private void processAudioSrc() {
        URL url = this.checkURL(this.currentElement().getAttribute("src"));
        if (url.fragment() != null) {
            this.report.message(MessageId.MED_014, this.location(), url.fragment());
            url = URLUtils.docURL(url);
        }
        if (url != null && this.context.container.isPresent()) {
            String mimeType = ((ResourceRegistry)this.context.resourceRegistry.get()).getMimeType(url);
            if (mimeType != null && !OPFChecker30.isBlessedAudioType(mimeType)) {
                this.report.message(MessageId.MED_005, this.location(), this.context.relativize(url), mimeType);
            }
            this.registerReference(url, Reference.Type.AUDIO, true);
            if (this.context.isRemote(url)) {
                this.requiredProperties.add(PackageVocabs.ITEM_PROPERTIES.REMOTE_RESOURCES);
            }
        }
    }

    private void processContentDocumentLink(URL url) {
        if (url != null && this.context.container.isPresent()) {
            assert (this.context.overlayTextChecker.isPresent());
            URL documentURL = URLUtils.docURL(url);
            if (!((OverlayTextChecker)this.context.overlayTextChecker.get()).registerOverlay(documentURL, ((OPFItem)this.context.opfItem.get()).getId())) {
                this.report.message(MessageId.MED_011, this.location(), this.context.relativize(url));
            }
            this.registerReference(url, Reference.Type.OVERLAY_TEXT_LINK);
        }
    }

    private void processGlobalAttrs() {
        XMLElement e = this.currentElement();
        this.checkType(e.getAttributeNS("http://www.idpf.org/2007/ops", "type"));
    }

    @Override
    public void endElement() {
        XMLElement e = this.currentElement();
        String name = e.getName();
        if (name.equals("smil")) {
            this.checkItemReferences();
            this.checkProperties();
        }
    }

    private void checkItemReferences() {
        if (this.resourceRefs.isEmpty()) {
            return;
        }
    }

    protected void checkProperties() {
        if (!this.context.container.isPresent()) {
            return;
        }
        Set<PackageVocabs.ITEM_PROPERTIES> itemProps = Property.filter(this.context.properties, PackageVocabs.ITEM_PROPERTIES.class);
        for (PackageVocabs.ITEM_PROPERTIES requiredProperty : Sets.difference(this.requiredProperties, itemProps)) {
            this.report.message(MessageId.OPF_014, EPUBLocation.of(this.context), PackageVocabs.ITEM_VOCAB.getName(requiredProperty));
        }
    }
}

