/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoreExtensionEntry {
    private final ClassRealm realm;
    private final Set<String> artifacts;
    private final Set<String> packages;
    private static final ExtensionDescriptorBuilder BUILDER = new ExtensionDescriptorBuilder();

    public CoreExtensionEntry(ClassRealm realm, Collection<String> artifacts, Collection<String> packages) {
        this.realm = realm;
        this.artifacts = Collections.unmodifiableSet(new HashSet<String>(artifacts));
        this.packages = Collections.unmodifiableSet(new HashSet<String>(packages));
    }

    public ClassRealm getClassRealm() {
        return this.realm;
    }

    public Set<String> getExportedArtifacts() {
        return this.artifacts;
    }

    public Set<String> getExportedPackages() {
        return this.packages;
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            Enumeration<URL> urls = loader.getResources(BUILDER.getExtensionDescriptorLocation());
            while (urls.hasMoreElements()) {
                InputStream is2 = urls.nextElement().openStream();
                Throwable throwable = null;
                try {
                    ExtensionDescriptor descriptor2 = BUILDER.build(is2);
                    artifacts.addAll(descriptor2.getExportedArtifacts());
                    packages.addAll(descriptor2.getExportedPackages());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is2 == null) continue;
                    if (throwable != null) {
                        try {
                            is2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is2.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages);
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader, Collection<File> classpath) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            for (File entry : classpath) {
                ExtensionDescriptor descriptor2 = BUILDER.build(entry);
                if (descriptor2 == null) continue;
                artifacts.addAll(descriptor2.getExportedArtifacts());
                packages.addAll(descriptor2.getExportedPackages());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages);
    }
}

