/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.traccar.api.BaseObjectResource;
import org.traccar.broadcast.BroadcastService;
import org.traccar.database.MediaManager;
import org.traccar.helper.LogAction;
import org.traccar.model.Device;
import org.traccar.model.DeviceAccumulators;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="devices")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DeviceResource
extends BaseObjectResource<Device> {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private BroadcastService broadcastService;
    @Inject
    private MediaManager mediaManager;

    public DeviceResource() {
        super(Device.class);
    }

    @GET
    public Collection<Device> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId, @QueryParam(value="uniqueId") List<String> uniqueIds, @QueryParam(value="id") List<Long> deviceIds) throws StorageException {
        if (!uniqueIds.isEmpty() || !deviceIds.isEmpty()) {
            LinkedList<Device> result = new LinkedList<Device>();
            for (String uniqueId : uniqueIds) {
                result.addAll(this.storage.getObjects(Device.class, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("uniqueId", uniqueId), new Condition.Permission(User.class, this.getUserId(), Device.class)))));
            }
            for (Long deviceId : deviceIds) {
                result.addAll(this.storage.getObjects(Device.class, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("id", deviceId), new Condition.Permission(User.class, this.getUserId(), Device.class)))));
            }
            return result;
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        if (all) {
            if (this.permissionsService.notAdmin(this.getUserId())) {
                conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
            }
        } else if (userId == 0L) {
            conditions.add(new Condition.Permission(User.class, this.getUserId(), this.baseClass));
        } else {
            this.permissionsService.checkUser(this.getUserId(), userId);
            conditions.add(new Condition.Permission(User.class, userId, this.baseClass).excludeGroups());
        }
        return this.storage.getObjects(this.baseClass, new Request((Columns)new Columns.All(), Condition.merge(conditions)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="{id}/accumulators")
    @PUT
    public Response updateAccumulators(DeviceAccumulators entity) throws StorageException {
        Position position;
        if (this.permissionsService.notAdmin(this.getUserId())) {
            this.permissionsService.checkManager(this.getUserId());
            this.permissionsService.checkPermission(Device.class, this.getUserId(), entity.getDeviceId());
        }
        if ((position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(entity.getDeviceId())))) != null) {
            if (entity.getTotalDistance() != null) {
                position.getAttributes().put("totalDistance", entity.getTotalDistance());
            }
            if (entity.getHours() != null) {
                position.getAttributes().put("hours", entity.getHours());
            }
            position.setId(this.storage.addObject(position, new Request(new Columns.Exclude("id"))));
            Device device = new Device();
            device.setId(position.getDeviceId());
            device.setPositionId(position.getId());
            this.storage.updateObject(device, new Request((Columns)new Columns.Include("positionId"), new Condition.Equals("id", device.getId())));
            try {
                this.cacheManager.addDevice(position.getDeviceId());
                this.cacheManager.updatePosition(position);
                this.connectionManager.updatePosition(true, position);
            }
            finally {
                this.cacheManager.removeDevice(position.getDeviceId());
            }
        } else {
            throw new IllegalArgumentException();
        }
        LogAction.resetDeviceAccumulators(this.getUserId(), entity.getDeviceId());
        return Response.noContent().build();
    }

    @Path(value="{id}/image")
    @POST
    @Consumes(value={"image/*"})
    public Response uploadImage(@PathParam(value="id") long deviceId, File file, @HeaderParam(value="Content-Type") String type) throws StorageException, IOException {
        Device device = this.storage.getObject(Device.class, new Request((Columns)new Columns.All(), new Condition.And(new Condition.Equals("id", deviceId), new Condition.Permission(User.class, this.getUserId(), Device.class))));
        if (device != null) {
            String name = "device";
            String extension = type.substring("image/".length());
            try (FileInputStream input = new FileInputStream(file);
                 OutputStream output = this.mediaManager.createFileStream(device.getUniqueId(), name, extension);){
                input.transferTo(output);
            }
            return Response.ok((Object)(name + "." + extension)).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

