/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;

public class DdlTypeImpl
implements DdlType {
    private final int sqlTypeCode;
    private final String typeNamePattern;
    private final String castTypeNamePattern;
    private final boolean castTypeNameIsStatic;
    private final Dialect dialect;

    public DdlTypeImpl(int sqlTypeCode, String typeNamePattern, Dialect dialect) {
        this(sqlTypeCode, typeNamePattern, typeNamePattern, dialect);
    }

    public DdlTypeImpl(int sqlTypeCode, String typeNamePattern, String castTypeNamePattern, Dialect dialect) {
        this.sqlTypeCode = sqlTypeCode;
        this.typeNamePattern = typeNamePattern;
        this.castTypeNamePattern = castTypeNamePattern;
        this.castTypeNameIsStatic = !castTypeNamePattern.contains("$s") && !castTypeNamePattern.contains("$l") && !castTypeNamePattern.contains("$p");
        this.dialect = dialect;
    }

    @Override
    public int getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    @Override
    public String getRawTypeName() {
        int paren = this.typeNamePattern.indexOf(40);
        if (paren > 0) {
            int parenEnd = this.typeNamePattern.lastIndexOf(41);
            return parenEnd + 1 == this.typeNamePattern.length() ? this.typeNamePattern.substring(0, paren) : this.typeNamePattern.substring(0, paren) + this.typeNamePattern.substring(parenEnd + 1);
        }
        return this.typeNamePattern;
    }

    @Override
    public String getTypeNamePattern() {
        return this.typeNamePattern;
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        return DdlTypeImpl.replace(this.typeNamePattern, size, precision, scale);
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType, Long length, Integer precision, Integer scale) {
        if (length == null && precision == null) {
            return this.getCastTypeName(jdbcType, javaType);
        }
        if (precision != null && scale == null) {
            scale = javaType.getDefaultSqlScale(this.dialect, jdbcType);
        }
        return this.getTypeName(length, precision, scale);
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType) {
        if (this.castTypeNameIsStatic) {
            return this.castTypeNamePattern;
        }
        Long length = null;
        Integer precision = null;
        Integer scale = null;
        switch (jdbcType.getDdlTypeCode()) {
            case 12: {
                length = this.dialect.getMaxVarcharLength();
                break;
            }
            case -9: {
                length = this.dialect.getMaxNVarcharLength();
                break;
            }
            case -3: {
                length = this.dialect.getMaxVarbinaryLength();
            }
        }
        Size size = this.dialect.getSizeStrategy().resolveSize(jdbcType, javaType, precision, scale, length);
        return DdlTypeImpl.replace(this.castTypeNamePattern, size.getLength(), size.getPrecision(), size.getScale());
    }

    public static String replace(String type, Long size, Integer precision, Integer scale) {
        if (scale != null) {
            type = StringHelper.replaceOnce(type, "$s", scale.toString());
        }
        if (size != null) {
            type = StringHelper.replaceOnce(type, "$l", size.toString());
        }
        if (precision != null) {
            type = StringHelper.replaceOnce(type, "$p", precision.toString());
        }
        return type;
    }
}

