/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8TTILobd;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.sql.Datum;

abstract class T4C8TTILob
extends T4CTTIfun {
    private static final String CLASS_NAME = T4C8TTILob.class.getName();
    static final int KPLOB_GET_LEN = 1;
    static final int KPLOB_READ = 2;
    static final int KPLOB_TRIM = 32;
    static final int KPLOB_WRITE = 64;
    static final int KPLOB_FILE_OPEN = 256;
    static final int KPLOB_FILE_CLOSE = 512;
    static final int KPLOB_FILE_ISOPEN = 1024;
    static final int KPLOB_FILE_EXISTS = 2048;
    static final int KPLOB_TMP_CREATE = 272;
    static final int KPLOB_TMP_FREE = 273;
    static final int KPLOB_TMP_CBK = 17;
    static final int KPLOB_WRITE_APPEND = 8192;
    static final int KPLOB_PAGE_SIZE = 16384;
    static final int KPLOB_OPEN = 32768;
    static final int KPLOB_CLOSE = 65536;
    static final int KPLOB_ISOPEN = 69632;
    static final int KPLOB_ARRAY_OPERATION = 524288;
    static final int KPLOB_ARRAY_TMPFR = 524561;
    static final int KOKL_ORDONLY = 1;
    static final int KOKL_ORDWR = 2;
    static final int KOLF_ORDONLY = 11;
    static final int DTYCLOB = 112;
    static final int DTYBLOB = 113;
    byte[] sourceLobLocator = null;
    byte[] destinationLobLocator = null;
    int destinationLength = 0;
    long sourceOffset = 0L;
    long destinationOffset = 0L;
    short characterSet = 0;
    long lobamt = 0L;
    boolean lobnull = false;
    long lobops = 0L;
    int[] lobscn = null;
    int lobscnl = 0;
    boolean nullO2U = false;
    boolean sendLobamt = false;
    byte[] inBuffer = null;
    long inBufferOffset;
    long inBufferNumBytes;
    byte[] outBuffer = null;
    int offsetInOutBuffer = 0;
    long rowsProcessed = 0L;
    long lobBytesRead = 0L;
    boolean littleEndianClob = false;
    T4C8TTILobd lobd = null;

    T4C8TTILob(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)96);
        this.lobd = new T4C8TTILobd(_conn);
    }

    long read(byte[] lobLocator, long offset, long _numBytes, byte[] outBuffer, int _offsetInOutBuffer) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.outBuffer = outBuffer;
        this.offsetInOutBuffer = _offsetInOutBuffer;
        this.doRPC();
        return this.lobBytesRead;
    }

    final CompletionStage<Long> readAsync(byte[] lobLocator, long offset, long _numBytes, byte[] outBuffer, int _offsetInOutBuffer, ErrorSet continueOnErrorSet) {
        this.initializeLobdef();
        this.lobops = 2L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.outBuffer = outBuffer;
        this.offsetInOutBuffer = _offsetInOutBuffer;
        return this.doRPCAsync(continueOnErrorSet).thenApply(nil -> this.lobBytesRead);
    }

    long write(byte[] lobLocator, long offset, byte[] _inBuffer, long _inBufferOffset, long _numBytes) throws SQLException, IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "write", "offset={0}, _inBufferOffset={1}, _numBytes={2}", (String)null, (Throwable)null, (Object)offset, (Object)_inBufferOffset, (Object)_numBytes);
        this.validateLobOperation(lobLocator, 64, "write()");
        long bytesWritten = 0L;
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.inBuffer = _inBuffer;
        this.inBufferOffset = _inBufferOffset;
        this.inBufferNumBytes = _numBytes;
        this.doRPC();
        bytesWritten = this.lobamt;
        return bytesWritten;
    }

    final CompletionStage<Long> writeAsync(byte[] lobLocator, long offset, byte[] _inBuffer, long _inBufferOffset, long _numBytes, ErrorSet continueOnErrorSet) {
        try {
            this.validateLobOperation(lobLocator, 64, "writeAsync()");
        }
        catch (SQLException ex) {
            return CompletableFuture.failedStage(ex);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = _numBytes;
        this.sendLobamt = true;
        this.inBuffer = _inBuffer;
        this.inBufferOffset = _inBufferOffset;
        this.inBufferNumBytes = _numBytes;
        return this.doRPCAsync(continueOnErrorSet).thenApply(nil -> this.lobamt);
    }

    long getLength(byte[] lobLocator) throws SQLException, IOException {
        this.prepareForGetLengthRPC(lobLocator);
        this.doRPC();
        return this.lobamt;
    }

    final CompletionStage<Long> getLengthAsync(byte[] lobLocator) {
        this.prepareForGetLengthRPC(lobLocator);
        return this.doRPCAsync().thenApply(nil -> this.lobamt);
    }

    private void prepareForGetLengthRPC(byte[] lobLocator) {
        this.initializeLobdef();
        this.lobops = 1L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
    }

    long getChunkSize(byte[] lobLocator) throws SQLException, IOException {
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
        this.doRPC();
        return this.lobamt;
    }

    void getChunkSizeAsync(byte[] lobLocator, BiConsumer<Long, Throwable> callback) {
        this.initializeLobdef();
        this.lobops = 16384L;
        this.sourceLobLocator = lobLocator;
        this.sendLobamt = true;
        this.doRPCAsync((Throwable error) -> callback.accept(error == null ? Long.valueOf(this.lobamt) : null, (Throwable)error));
    }

    long trim(byte[] lobLocator, long newLength) throws SQLException, IOException {
        this.validateLobOperation(lobLocator, 32, "trim()");
        long newLengthfromServer = 0L;
        this.initializeLobdef();
        this.lobops = 32L;
        this.sourceLobLocator = lobLocator;
        this.lobamt = newLength;
        this.sendLobamt = true;
        this.doRPC();
        newLengthfromServer = this.lobamt;
        return newLengthfromServer;
    }

    abstract Datum createTemporaryLob(Connection var1, boolean var2, int var3) throws SQLException, IOException;

    void doFreeLobPiggyback() throws SQLException, IOException {
        if (this.connection.tempLobFreeOffset > 0) {
            this.initializeLobdef();
            this.lobops = 524561L;
            this.sourceLobLocator = new byte[this.connection.tempLobFreeOffset];
            System.arraycopy(this.connection.tempLobsToFree, 0, this.sourceLobLocator, 0, this.connection.tempLobFreeOffset);
            this.setTTCCode((byte)17);
            this.doPigRPC();
            this.resetLobPiggyback();
        }
    }

    void resetLobPiggyback() {
        this.connection.tempLobFreeOffset = 0;
        this.connection.tempLobFreeCount = 0;
    }

    void freeTemporaryLob(byte[] lobLocator) throws SQLException, IOException {
        if (PhysicalConnection.isQuasiLocator(lobLocator) || !PhysicalConnection.isTemporary(lobLocator)) {
            return;
        }
        if (this.connection.getTTCVersion() >= 4) {
            if ((lobLocator[5] & 8) == 0 || !this.isAbstractLocator(lobLocator) && !this.isTemporaryLocator(lobLocator)) {
                throw new SQLException("ORA-22275: invalid LOB locator specified\n", "22275", 22275);
            }
            this.copyTemporaryLobToFree(lobLocator);
            lobLocator[4] = (byte)(lobLocator[4] & 0xFFFFFFBF);
            lobLocator[5] = (byte)(lobLocator[5] & 0xFFFFFFF7);
            lobLocator[7] = (byte)(lobLocator[7] & 0xFFFFFFFE);
        } else {
            this.initializeLobdef();
            this.lobops = 273L;
            this.sourceLobLocator = lobLocator;
            this.doRPC();
        }
    }

    void copyTemporaryLobToFree(byte[] lobLocators) {
        if (this.connection.tempLobFreeOffset + lobLocators.length > this.connection.tempLobsToFree.length) {
            byte[] tempBuf = new byte[this.connection.tempLobsToFree.length * 2];
            System.arraycopy(this.connection.tempLobsToFree, 0, tempBuf, 0, this.connection.tempLobsToFree.length);
            this.connection.tempLobsToFree = tempBuf;
        }
        System.arraycopy(lobLocators, 0, this.connection.tempLobsToFree, this.connection.tempLobFreeOffset, lobLocators.length);
        this.connection.tempLobFreeOffset += lobLocators.length;
    }

    abstract boolean open(byte[] var1, int var2) throws SQLException, IOException;

    boolean _open(byte[] lobLocator, int mode, int lobops) throws SQLException, IOException {
        boolean didOpen = false;
        if (PhysicalConnection.isQuasiLocator(lobLocator)) {
            return didOpen;
        }
        if (this.isTemporaryLocator(lobLocator) || this.isAbstractLocator(lobLocator)) {
            if (this.isOpenLocator(lobLocator)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 445).fillInStackTrace();
            }
            lobLocator[7] = (byte)(lobLocator[7] | 8);
            if (mode == 2) {
                lobLocator[7] = (byte)(lobLocator[7] | 0x10);
            }
            didOpen = true;
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.lobamt = mode;
            this.sendLobamt = true;
            this.doRPC();
            if (this.lobamt != 0L) {
                didOpen = true;
            }
        }
        return didOpen;
    }

    abstract boolean close(byte[] var1) throws SQLException, IOException;

    boolean _close(byte[] lobLocator, int lobops) throws SQLException, IOException {
        boolean isClosed = true;
        if (PhysicalConnection.isQuasiLocator(lobLocator)) {
            return isClosed;
        }
        if (this.isTemporaryLocator(lobLocator) || this.isAbstractLocator(lobLocator)) {
            if (!this.isOpenLocator(lobLocator)) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446).fillInStackTrace();
            }
            lobLocator[7] = (byte)(lobLocator[7] & 0xFFFFFFE7);
        } else {
            this.initializeLobdef();
            this.sourceLobLocator = lobLocator;
            this.lobops = lobops;
            this.doRPC();
        }
        return isClosed;
    }

    final CompletionStage<Void> _closeAsync(byte[] lobLocator, int lobops) {
        if (PhysicalConnection.isQuasiLocator(lobLocator)) {
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        if (this.isTemporaryLocator(lobLocator) || this.isAbstractLocator(lobLocator)) {
            if (!this.isOpenLocator(lobLocator)) {
                return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 446).fillInStackTrace());
            }
            lobLocator[7] = (byte)(lobLocator[7] & 0xFFFFFFE7);
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        this.initializeLobdef();
        this.sourceLobLocator = lobLocator;
        this.lobops = lobops;
        return this.doRPCAsync();
    }

    private boolean isTemporaryLocator(byte[] lobLocator) {
        return (lobLocator[7] & 1) == 1;
    }

    private boolean isAbstractLocator(byte[] lobLocator) {
        return (lobLocator[4] & 0x40) == 64;
    }

    private boolean isOpenLocator(byte[] lobLocator) {
        return (lobLocator[7] & 8) == 8;
    }

    abstract boolean isOpen(byte[] var1) throws SQLException, IOException;

    boolean _isOpen(byte[] lobLocator, int lobops) throws SQLException, IOException {
        Boolean isOpenLocal = this.isOpenLocal(lobLocator);
        if (isOpenLocal != null) {
            return isOpenLocal;
        }
        this.initializeLobdef();
        this.sourceLobLocator = lobLocator;
        this.lobops = lobops;
        this.nullO2U = true;
        this.doRPC();
        return this.lobnull;
    }

    CompletionStage<Boolean> _isOpenAsync(byte[] lobLocator, int lobops) {
        Boolean isOpenLocal = this.isOpenLocal(lobLocator);
        if (isOpenLocal != null) {
            return CompletableFuture.completedStage(isOpenLocal);
        }
        this.initializeLobdef();
        this.sourceLobLocator = lobLocator;
        this.lobops = lobops;
        this.nullO2U = true;
        return this.doRPCAsync().thenApply(nil -> this.lobnull);
    }

    private Boolean isOpenLocal(byte[] lobLocator) {
        if (PhysicalConnection.isQuasiLocator(lobLocator)) {
            return false;
        }
        if (this.isTemporaryLocator(lobLocator) || this.isAbstractLocator(lobLocator)) {
            return this.isOpenLocator(lobLocator);
        }
        return null;
    }

    void initializeLobdef() {
        this.setTTCCode((byte)3);
        this.sourceLobLocator = null;
        this.destinationLobLocator = null;
        this.sourceOffset = 0L;
        this.destinationOffset = 0L;
        this.destinationLength = 0;
        this.characterSet = 0;
        this.lobamt = 0L;
        this.lobnull = false;
        this.lobops = 0L;
        this.lobscn = null;
        this.lobscnl = 0;
        this.inBuffer = null;
        this.outBuffer = null;
        this.nullO2U = false;
        this.sendLobamt = false;
        this.littleEndianClob = false;
        this.lobBytesRead = 0L;
    }

    @Override
    void marshal() throws IOException {
        int slength = 0;
        if (this.sourceLobLocator != null) {
            slength = this.sourceLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(slength);
        if (this.destinationLobLocator != null) {
            this.destinationLength = this.destinationLobLocator.length;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.destinationLength);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.sourceOffset);
        }
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalUB4(0L);
        } else {
            this.meg.marshalUB4(this.destinationOffset);
        }
        if (this.characterSet != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.nullO2U) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.lobops);
        if (this.lobscnl != 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalSB4(this.lobscnl);
        if (this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.sourceOffset);
            this.meg.marshalSB8(this.destinationOffset);
            if (this.sendLobamt) {
                this.meg.marshalPTR();
            } else {
                this.meg.marshalNULLPTR();
            }
            if (this.connection.getTTCVersion() >= 4) {
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
                this.meg.marshalNULLPTR();
                this.meg.marshalSWORD(0);
            }
        }
        if (this.sourceLobLocator != null) {
            this.meg.marshalB1Array(this.sourceLobLocator);
        }
        if (this.destinationLobLocator != null) {
            this.meg.marshalB1Array(this.destinationLobLocator);
        }
        if (this.characterSet != 0) {
            this.meg.marshalUB2(this.characterSet);
        }
        if (this.sendLobamt && this.connection.getTTCVersion() < 3) {
            this.meg.marshalUB4(this.lobamt);
        }
        if (this.lobscnl != 0) {
            for (int i = 0; i < this.lobscnl; ++i) {
                this.meg.marshalUB4(this.lobscn[i]);
            }
        }
        if (this.sendLobamt && this.connection.getTTCVersion() >= 3) {
            this.meg.marshalSB8(this.lobamt);
        }
        if (this.lobops == 64L) {
            this.marshalData();
        }
    }

    void marshalData() throws IOException {
        boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean varWidthChar = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            varWidthChar = true;
        }
        if (this.connection.versionNumber < 10101 && varWidthChar) {
            this.lobd.marshalClobUB2_For9iDB(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes);
        } else {
            this.lobd.marshalLobData(this.inBuffer, this.inBufferOffset, this.inBufferNumBytes, useZeroCopyIO);
        }
    }

    @Override
    void readLOBD() throws IOException, SQLException {
        boolean useZeroCopyIO = this.connection.isZeroCopyIOEnabled() & (this.sourceLobLocator[7] & 0xFFFFFF80) != 0;
        boolean varWidthChar = false;
        if ((this.sourceLobLocator[6] & 0x80) == 128) {
            varWidthChar = true;
        }
        this.lobBytesRead = this.connection.versionNumber < 10101 && varWidthChar ? this.lobd.unmarshalClobUB2_For9iDB(this.outBuffer, this.offsetInOutBuffer) : this.lobd.unmarshalLobData(this.outBuffer, this.offsetInOutBuffer, useZeroCopyIO);
    }

    @Override
    void processError() throws SQLException {
        this.rowsProcessed = this.oer.getCurRowNumber();
        if (this.oer.getRetCode() != 1403L) {
            this.oer.processError();
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        short isNull;
        int length;
        if (this.sourceLobLocator != null) {
            if (this.lobops == 272L) {
                this.meg.getNBytes(this.sourceLobLocator, 0, 2);
                byte b0 = this.sourceLobLocator[0];
                byte b1 = this.sourceLobLocator[1];
                short locatorLen = (short)(b0 << 8 | b1);
                int extraUnusedLocatorBytes = 0;
                if (locatorLen + 2 != this.sourceLobLocator.length) {
                    if (this.sourceLobLocator.length > locatorLen + 2) {
                        extraUnusedLocatorBytes = (short)(this.sourceLobLocator.length - (locatorLen + 2));
                    }
                    this.sourceLobLocator = new byte[locatorLen + 2];
                    this.sourceLobLocator[0] = b0;
                    this.sourceLobLocator[1] = b1;
                }
                this.meg.getNBytes(this.sourceLobLocator, 2, locatorLen);
                if (extraUnusedLocatorBytes > 0) {
                    byte[] temp = new byte[extraUnusedLocatorBytes];
                    this.meg.getNBytes(temp, 0, extraUnusedLocatorBytes);
                }
            } else {
                length = this.sourceLobLocator.length;
                this.meg.getNBytes(this.sourceLobLocator, 0, length);
            }
        }
        if (this.destinationLobLocator != null) {
            length = this.meg.unmarshalSB2();
            this.destinationLobLocator = this.meg.unmarshalNBytes(length);
        }
        if (this.characterSet != 0) {
            this.characterSet = this.meg.unmarshalSB2();
        }
        if (this.sendLobamt) {
            this.lobamt = this.connection.getTTCVersion() >= 3 ? this.meg.unmarshalSB8() : this.meg.unmarshalUB4();
        }
        if (this.nullO2U && (isNull = (short)this.meg.unmarshalSB1()) != 0) {
            this.lobnull = true;
        }
    }

    int getTemporaryLobSize() {
        try {
            if (this.connection.getVersionNumber() >= 19000) {
                return 108;
            }
            return 40;
        }
        catch (SQLException sqe) {
            return 40;
        }
    }

    void validateLobOperation(byte[] lobLocator, int lobOperation, String caller) throws SQLException {
        switch (lobOperation) {
            case 32: 
            case 64: {
                if (PhysicalConnection.isValueBasedLocator(lobLocator)) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 454, caller).fillInStackTrace();
                }
                if (!PhysicalConnection.isReadOnly(lobLocator)) break;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 455, caller).fillInStackTrace();
            }
        }
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

