/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public interface GroupModel
extends RoleMapperModel {
    public static final Comparator<GroupModel> COMPARE_BY_NAME = Comparator.comparing(GroupModel::getName);

    public String getId();

    public String getName();

    public void setName(String var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public GroupModel getParent();

    public String getParentId();

    public Stream<GroupModel> getSubGroupsStream();

    public void setParent(GroupModel var1);

    public void addChild(GroupModel var1);

    public void removeChild(GroupModel var1);

    public static interface GroupPathChangeEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public String getNewPath();

        public String getPreviousPath();

        public KeycloakSession getKeycloakSession();
    }

    public static interface GroupRemovedEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public GroupModel getGroup();

        public KeycloakSession getKeycloakSession();
    }

    public static class SearchableFields {
        public static final SearchableModelField<GroupModel> ID = new SearchableModelField("id", String.class);
        public static final SearchableModelField<GroupModel> REALM_ID = new SearchableModelField("realmId", String.class);
        public static final SearchableModelField<GroupModel> PARENT_ID = new SearchableModelField("parentGroupId", String.class);
        public static final SearchableModelField<GroupModel> NAME = new SearchableModelField("name", String.class);
        public static final SearchableModelField<GroupModel> ASSIGNED_ROLE = new SearchableModelField("assignedRole", String.class);
        public static final SearchableModelField<GroupModel> ATTRIBUTE = new SearchableModelField("attribute", String[].class);
    }
}

