/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.keycloak.validate.ValidationError;

public final class ValidationException
extends RuntimeException
implements Consumer<ValidationError> {
    private final Map<String, List<Error>> errors = new HashMap<String, List<Error>>();

    public List<Error> getErrors() {
        return this.errors.values().stream().reduce(new ArrayList(), (l, r) -> {
            l.addAll(r);
            return l;
        }, (l, r) -> l);
    }

    public boolean hasError(String ... types) {
        if (types.length == 0) {
            return !this.errors.isEmpty();
        }
        for (String type : types) {
            if (!this.errors.containsKey(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeOnError(String ... name) {
        if (name.length == 0) {
            return !this.errors.isEmpty();
        }
        List<String> names = Arrays.asList(name);
        return this.errors.values().stream().flatMap(Collection::stream).anyMatch(error -> names.contains(error.getAttribute()));
    }

    @Override
    public void accept(ValidationError error) {
        this.addError(error);
    }

    void addError(ValidationError error) {
        List errors = this.errors.computeIfAbsent(error.getMessage(), k -> new ArrayList());
        errors.add(new Error(error));
    }

    @Override
    public String toString() {
        return "ValidationException [errors=" + this.errors + "]";
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    public Response.Status getStatusCode() {
        for (Map.Entry<String, List<Error>> entry : this.errors.entrySet()) {
            for (Error error : entry.getValue()) {
                if (Response.Status.BAD_REQUEST.equals((Object)error.getStatusCode())) continue;
                return error.getStatusCode();
            }
        }
        return Response.Status.BAD_REQUEST;
    }

    public static class Error
    implements Serializable {
        private final ValidationError error;

        public Error(ValidationError error) {
            this.error = error;
        }

        public String getAttribute() {
            return this.error.getInputHint();
        }

        public String getMessage() {
            return this.error.getMessage();
        }

        public Object[] getMessageParameters() {
            return this.error.getInputHintWithMessageParameters();
        }

        public String toString() {
            return "Error [error=" + this.error + "]";
        }

        public String getFormattedMessage(BiFunction<String, Object[], String> messageFormatter) {
            return messageFormatter.apply(this.getMessage(), this.getMessageParameters());
        }

        public Response.Status getStatusCode() {
            return this.error.getStatusCode();
        }
    }
}

