/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.ReceiveSsrc;
import org.jitsi.videobridge.SendSource;
import org.jitsi.videobridge.SourceDesc;
import org.jitsi.videobridge.SsrcCache;
import org.jitsi.videobridge.SsrcCacheKt;
import org.jitsi.videobridge.SsrcRewriter;
import org.json.simple.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 92\u00020\u0001:\u00019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0016H$J\u0006\u0010'\u001a\u00020(J0\u0010)\u001a\u0004\u0018\u00010\u001c2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\f2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0-H\u0002J\u0016\u0010.\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\"H$J\u000e\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\f2\u0006\u00100\u001a\u0002032\b\b\u0002\u00104\u001a\u00020\fJ\u0006\u00105\u001a\u00020 J\b\u00106\u001a\u00020\tH\u0016J\u0010\u00107\u001a\u0004\u0018\u00010\t2\u0006\u00100\u001a\u000208R\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006:"}, d2={"Lorg/jitsi/videobridge/SsrcCache;", "", "size", "", "ep", "Lorg/jitsi/videobridge/SsrcRewriter;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "label", "", "(ILorg/jitsi/videobridge/SsrcRewriter;Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;)V", "allowCreateOnPacket", "", "getAllowCreateOnPacket", "()Z", "getEp", "()Lorg/jitsi/videobridge/SsrcRewriter;", "logger", "getParentLogger", "()Lorg/jitsi/utils/logging2/Logger;", "receivedSsrcs", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/ReceiveSsrc;", "Lkotlin/collections/HashMap;", "remapCount", "sendSources", "Lorg/jitsi/utils/LRUCache;", "Lorg/jitsi/videobridge/SendSource;", "getSize", "()I", "activate", "", "sources", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "findSourceProps", "Lorg/jitsi/videobridge/SourceDesc;", "ssrc", "getDebugState", "Lorg/json/simple/JSONObject;", "getSendSource", "props", "allowCreate", "remappings", "", "notifyMappings", "rewriteRtcp", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "rewriteRtp", "Lorg/jitsi/rtp/rtp/RtpPacket;", "start", "sendAllMappings", "toString", "unmapRtcpFbSsrc", "Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "Companion", "jitsi-videobridge"})
public abstract class SsrcCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final SsrcRewriter ep;
    @NotNull
    private final Logger parentLogger;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Long, ReceiveSsrc> receivedSsrcs;
    @NotNull
    private final LRUCache<Long, SendSource> sendSources;
    private int remapCount;

    /*
     * WARNING - void declaration
     */
    public SsrcCache(int size, @NotNull SsrcRewriter ep, @NotNull Logger parentLogger, @NotNull String label) {
        void $this$logger_u24lambda_u2d0;
        Logger logger;
        Intrinsics.checkNotNullParameter(ep, "ep");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(label, "label");
        this.size = size;
        this.ep = ep;
        this.parentLogger = parentLogger;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default(this, this.parentLogger, null, 2, null);
        SsrcCache ssrcCache = this;
        boolean bl = false;
        $this$logger_u24lambda_u2d0.addContext("type", label);
        ssrcCache.logger = logger;
        this.receivedSsrcs = new HashMap();
        this.sendSources = new LRUCache(this.size, true);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final SsrcRewriter getEp() {
        return this.ep;
    }

    @NotNull
    public final Logger getParentLogger() {
        return this.parentLogger;
    }

    protected abstract boolean getAllowCreateOnPacket();

    @Nullable
    protected abstract SourceDesc findSourceProps(long var1);

    protected abstract void notifyMappings(@NotNull List<SendSource> var1);

    private final SendSource getSendSource(long ssrc2, SourceDesc props, boolean allowCreate, List<SendSource> remappings) {
        Ref.ObjectRef sendSource = new Ref.ObjectRef();
        sendSource.element = this.sendSources.get(ssrc2);
        if (sendSource.element == null) {
            if (!allowCreate) {
                return null;
            }
            if (this.sendSources.size() == this.size) {
                Map.Entry<Long, SendSource> eldest = this.sendSources.eldest();
                sendSource.element = new SendSource(props, eldest.getValue().getSend1(), eldest.getValue().getSend2());
                this.logger.debug(() -> SsrcCache.getSendSource$lambda-1(props, sendSource, eldest));
                ReceiveSsrc receiveSsrc = this.receivedSsrcs.get(props.getSsrc1());
                if (receiveSsrc != null) {
                    receiveSsrc.setHasDeltas(false);
                }
                if (props.getSsrc2() != -1L) {
                    ReceiveSsrc receiveSsrc2 = this.receivedSsrcs.get(props.getSsrc2());
                    if (receiveSsrc2 != null) {
                        receiveSsrc2.setHasDeltas(false);
                    }
                }
                ++this.remapCount;
            } else {
                long ssrc1 = this.ep.getNextSendSsrc();
                long ssrc22 = this.ep.getNextSendSsrc();
                sendSource.element = new SendSource(props, ssrc1, ssrc22);
                this.logger.debug(() -> SsrcCache.getSendSource$lambda-2(props, sendSource));
            }
            this.sendSources.put(ssrc2, (SendSource)sendSource.element);
            remappings.add((SendSource)sendSource.element);
        }
        return (SendSource)sendSource.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void activate(@NotNull List<MediaSourceDesc> sources) {
        Intrinsics.checkNotNullParameter(sources, "sources");
        List remappings = new ArrayList();
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = sources;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaSourceDesc source = (MediaSourceDesc)element$iv$iv;
                boolean bl2 = false;
                if (!(this.sendSources.get(source.getPrimarySSRC()) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSourceDesc source = (MediaSourceDesc)element$iv;
                boolean bl3 = false;
                this.getSendSource(source.getPrimarySSRC(), new SourceDesc(source), true, remappings);
            }
            this.logger.debug(() -> SsrcCache.activate$lambda-6$lambda-5(this));
            Unit unit = Unit.INSTANCE;
        }
        if (!((Collection)remappings).isEmpty()) {
            this.notifyMappings(remappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendAllMappings() {
        List<SendSource> remappings = null;
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            boolean bl = false;
            Collection collection = this.sendSources.values();
            Intrinsics.checkNotNullExpressionValue(collection, "sendSources.values");
            remappings = CollectionsKt.toList(collection);
            Unit unit = Unit.INSTANCE;
        }
        if (!((Collection)remappings).isEmpty()) {
            this.notifyMappings(remappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean rewriteRtp(@NotNull RtpPacket packet, boolean start) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        List remappings = new ArrayList();
        Ref.BooleanRef send = new Ref.BooleanRef();
        this.logger.debug(() -> SsrcCache.rewriteRtp$lambda-8(packet));
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            SendSource ss;
            boolean bl = false;
            Ref.ObjectRef rs = new Ref.ObjectRef();
            rs.element = this.receivedSsrcs.get(packet.getSsrc());
            if (rs.element == null) {
                SourceDesc sourceDesc = this.findSourceProps(packet.getSsrc());
                if (sourceDesc == null) {
                    return false;
                }
                SourceDesc props = sourceDesc;
                rs.element = new ReceiveSsrc(props);
                this.receivedSsrcs.put(packet.getSsrc(), (ReceiveSsrc)rs.element);
                this.logger.debug(() -> SsrcCache.rewriteRtp$lambda-13$lambda-9(packet));
            }
            if ((ss = this.getSendSource(((ReceiveSsrc)rs.element).getProps().getSsrc1(), ((ReceiveSsrc)rs.element).getProps(), this.getAllowCreateOnPacket(), remappings)) != null) {
                send.element = ss.rewriteRtp(packet, start, (ReceiveSsrc)rs.element);
                this.logger.debug(() -> SsrcCache.rewriteRtp$lambda-13$lambda-10(this));
                this.logger.debug(() -> SsrcCache.rewriteRtp$lambda-13$lambda-11(send, packet, rs, start));
            } else {
                this.logger.debug(() -> SsrcCache.rewriteRtp$lambda-13$lambda-12(rs, packet));
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!(!((Collection)remappings).isEmpty())) return send.element;
        this.notifyMappings(remappings);
        return send.element;
    }

    public static /* synthetic */ boolean rewriteRtp$default(SsrcCache ssrcCache, RtpPacket rtpPacket, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rewriteRtp");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return ssrcCache.rewriteRtp(rtpPacket, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean rewriteRtcp(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        List remappings = new ArrayList();
        long senderSsrc = packet.getSenderSsrc();
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            SendSource sendSource;
            block6: {
                ReceiveSsrc receiveSsrc;
                block5: {
                    boolean bl = false;
                    receiveSsrc = this.receivedSsrcs.get(packet.getSenderSsrc());
                    if (receiveSsrc != null) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                Intrinsics.checkNotNullExpressionValue(receiveSsrc, "receivedSsrcs.get(packet\u2026nderSsrc) ?: return false");
                ReceiveSsrc rs = receiveSsrc;
                if (this.getSendSource(rs.getProps().getSsrc1(), rs.getProps(), false, remappings) != null) break block6;
                boolean bl = false;
                return bl;
            }
            SendSource ss = sendSource;
            ss.rewriteRtcp(packet);
            this.logger.debug(() -> SsrcCache.rewriteRtcp$lambda-15$lambda-14(senderSsrc, packet));
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String unmapRtcpFbSsrc(@NotNull RtcpFbPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        long mediaSsrc = packet.getMediaSourceSsrc();
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            block10: {
                Object v2;
                block9: {
                    boolean bl = false;
                    Collection collection = this.sendSources.values();
                    Intrinsics.checkNotNullExpressionValue(collection, "sendSources.values");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        boolean bl2;
                        SendSource sendSource = (SendSource)t;
                        boolean bl3 = false;
                        if (mediaSsrc == sendSource.getSend1().getSsrc()) {
                            packet.setMediaSourceSsrc(sendSource.getProps().getSsrc1());
                            bl2 = true;
                        } else if (mediaSsrc == sendSource.getSend2().getSsrc()) {
                            packet.setMediaSourceSsrc(sendSource.getProps().getSsrc2());
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        v2 = t;
                        break block9;
                    }
                    v2 = null;
                }
                SendSource ss = v2;
                if (ss == null) break block10;
                this.logger.debug(() -> SsrcCache.unmapRtcpFbSsrc$lambda-19$lambda-17(mediaSsrc, packet, ss));
                String string = ss.getProps().getOwner();
                return string;
            }
            this.logger.debug(() -> SsrcCache.unmapRtcpFbSsrc$lambda-19$lambda-18(mediaSsrc));
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONObject getDebugState() {
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            JSONObject jSONObject;
            boolean bl = false;
            JSONObject $this$getDebugState_u24lambda_u2d21_u24lambda_u2d20 = jSONObject = new JSONObject();
            boolean bl2 = false;
            $this$getDebugState_u24lambda_u2d21_u24lambda_u2d20.put("max", this.size);
            $this$getDebugState_u24lambda_u2d21_u24lambda_u2d20.put("received", this.receivedSsrcs.size());
            $this$getDebugState_u24lambda_u2d21_u24lambda_u2d20.put("sent", this.sendSources.size());
            $this$getDebugState_u24lambda_u2d21_u24lambda_u2d20.put("remappings", this.remapCount);
            JSONObject jSONObject2 = jSONObject;
            return jSONObject2;
        }
    }

    @NotNull
    public String toString() {
        Set<Map.Entry<Long, ReceiveSsrc>> set = this.receivedSsrcs.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "receivedSsrcs.entries");
        String string = CollectionsKt.joinToString$default(set, ", ", "[", "]", 0, null, toString.1.INSTANCE, 24, null);
        Set set2 = this.sendSources.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "sendSources.entries");
        return "SSRCs: received=" + string + " mappings=" + CollectionsKt.joinToString$default(set2, ", ", "[", "]", 0, null, toString.2.INSTANCE, 24, null);
    }

    private static final String getSendSource$lambda-1(SourceDesc $props, Ref.ObjectRef $sendSource, Map.Entry $eldest) {
        Intrinsics.checkNotNullParameter($props, "$props");
        Intrinsics.checkNotNullParameter($sendSource, "$sendSource");
        return "Remapping SSRC: " + $props.getSsrc1() + "->" + $sendSource.element + ". " + $eldest.getKey() + "->inactive";
    }

    private static final String getSendSource$lambda-2(SourceDesc $props, Ref.ObjectRef $sendSource) {
        Intrinsics.checkNotNullParameter($props, "$props");
        Intrinsics.checkNotNullParameter($sendSource, "$sendSource");
        return "Added send SSRC: " + $props.getSsrc1() + "->" + $sendSource.element;
    }

    private static final String activate$lambda-6$lambda-5(SsrcCache this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.toString();
    }

    private static final String rewriteRtp$lambda-8(RtpPacket $packet) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "Received packet: " + SsrcCache.Companion.debugInfo($packet);
    }

    private static final String rewriteRtp$lambda-13$lambda-9(RtpPacket $packet) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "Added receive SSRC: " + $packet.getSsrc();
    }

    private static final String rewriteRtp$lambda-13$lambda-10(SsrcCache this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.toString();
    }

    private static final String rewriteRtp$lambda-13$lambda-11(Ref.BooleanRef $send, RtpPacket $packet, Ref.ObjectRef $rs, boolean $start) {
        Intrinsics.checkNotNullParameter($send, "$send");
        Intrinsics.checkNotNullParameter($packet, "$packet");
        Intrinsics.checkNotNullParameter($rs, "$rs");
        return $send.element ? "Sending packet: " + SsrcCache.Companion.debugInfo($packet) + " source=" + ((ReceiveSsrc)$rs.element).getProps().getName() + " start=" + $start : "Dropping packet from " + ((ReceiveSsrc)$rs.element).getProps().getName() + "/" + $packet.getSsrc() + ". waiting for key frame.";
    }

    private static final String rewriteRtp$lambda-13$lambda-12(Ref.ObjectRef $rs, RtpPacket $packet) {
        Intrinsics.checkNotNullParameter($rs, "$rs");
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "Dropping packet from " + ((ReceiveSsrc)$rs.element).getProps().getName() + "/" + $packet.getSsrc() + ". source not active.";
    }

    private static final String rewriteRtcp$lambda-15$lambda-14(long $senderSsrc, RtcpPacket $packet) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "Received RTCP packet. Translated receive SSRC " + $senderSsrc + " to send SSRC " + $packet.getSenderSsrc() + ".";
    }

    private static final String unmapRtcpFbSsrc$lambda-19$lambda-17(long $mediaSsrc, RtcpFbPacket $packet, SendSource $ss) {
        Intrinsics.checkNotNullParameter($packet, "$packet");
        return "Received RTCP FB packet. Translated send SSRC " + $mediaSsrc + " to receive SSRC " + $packet.getMediaSourceSsrc() + ". Owner = " + $ss.getProps().getOwner() + ".";
    }

    private static final String unmapRtcpFbSsrc$lambda-19$lambda-18(long $mediaSsrc) {
        return "Received RTCP FB packet for SSRC " + $mediaSsrc + ". Not active.";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/videobridge/SsrcCache$Companion;", "", "()V", "debugInfo", "", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        private final String debugInfo(RtpPacket packet) {
            int tl0Index = SsrcCacheKt.access$getTl0Index(packet);
            Object tl0Info = tl0Index != -1 ? " tl0PicIdx=" + tl0Index : "";
            return "ssrc=" + packet.getSsrc() + " seq=" + packet.getSequenceNumber() + " ts=" + packet.getTimestamp() + (String)tl0Info;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

