/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointConnectionStatusConfig;
import org.jitsi.videobridge.message.EndpointConnectionStatusMessage;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/videobridge/EndpointConnectionStatusMonitor;", "", "conference", "Lorg/jitsi/videobridge/Conference;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "(Lorg/jitsi/videobridge/Conference;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "inactiveEndpointIds", "", "", "logger", "taskHandle", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ScheduledFuture;", "endpointConnected", "", "endpointId", "monitorEndpointActivity", "endpoint", "Lorg/jitsi/videobridge/Endpoint;", "notifyStatusChange", "subjectEpId", "isConnected", "", "receiverEpId", "run", "start", "stop", "Companion", "jitsi-videobridge"})
public final class EndpointConnectionStatusMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Conference conference;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Set<String> inactiveEndpointIds;
    @NotNull
    private final AtomicReference<ScheduledFuture<?>> taskHandle;
    @JvmField
    @NotNull
    public static final CounterMetric endpointsDisconnected = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_disconnected", "Endpoints detected as temporarily inactive/disconnected due to inactivity.", 0L, 4, null);
    @JvmField
    @NotNull
    public static final CounterMetric endpointsReconnected = MetricsContainer.registerCounter$default(VideobridgeMetricsContainer.Companion.getInstance(), "endpoints_reconnected", "Endpoints reconnected after being detected as temporarily inactive/disconnected due to inactivity.", 0L, 4, null);

    @JvmOverloads
    public EndpointConnectionStatusMonitor(@NotNull Conference conference, @NotNull ScheduledExecutorService executor, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.conference = conference;
        this.executor = executor;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.inactiveEndpointIds = new LinkedHashSet();
        this.taskHandle = new AtomicReference<Object>(null);
    }

    public /* synthetic */ EndpointConnectionStatusMonitor(Conference conference, ScheduledExecutorService scheduledExecutorService, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(conference, scheduledExecutorService, logger, clock);
    }

    public final void start() {
        if (this.taskHandle.compareAndSet(null, this.executor.scheduleWithFixedDelay(this::run, EndpointConnectionStatusConfig.config.getIntervalMs(), EndpointConnectionStatusConfig.config.getIntervalMs(), TimeUnit.MILLISECONDS))) {
            this.logger.info("Starting connection status monitor");
        } else {
            this.logger.warn("Task already started, not starting again");
        }
    }

    public final void stop() {
        ScheduledFuture scheduledFuture = this.taskHandle.getAndSet(null);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.logger.info("Stopped");
    }

    /*
     * WARNING - void declaration
     */
    private final void run() {
        void $this$filterTo$iv$iv;
        List<Endpoint> list = this.conference.getLocalEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, "conference.localEndpoints");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Endpoint it = (Endpoint)element$iv$iv;
            boolean bl = false;
            if (!(!it.getVisitor())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Endpoint p0 = (Endpoint)element$iv;
            boolean bl = false;
            this.monitorEndpointActivity(p0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void monitorEndpointActivity(Endpoint endpoint) {
        Instant now = this.clock.instant();
        Instant mostRecentChannelCreatedTime = endpoint.getCreationTime();
        Instant lastActivity = endpoint.getLastIncomingActivity();
        boolean active = false;
        boolean changed = false;
        if (Intrinsics.areEqual(lastActivity, ClockUtils.NEVER)) {
            Duration timeSinceCreation = Duration.between(mostRecentChannelCreatedTime, now);
            if (timeSinceCreation.compareTo(EndpointConnectionStatusConfig.config.getFirstTransferTimeout()) > 0) {
                active = false;
                Set<String> set = this.inactiveEndpointIds;
                synchronized (set) {
                    boolean $i$a$-synchronized-EndpointConnectionStatusMonitor$monitorEndpointActivity$22 = false;
                    boolean alreadyInactive = this.inactiveEndpointIds.contains(endpoint.getId());
                    if (!alreadyInactive) {
                        Logger $this$cdebug$iv = this.logger;
                        boolean $i$f$cdebug = false;
                        if ($this$cdebug$iv.isDebugEnabled()) {
                            Logger logger = $this$cdebug$iv;
                            boolean bl = false;
                            logger.debug(endpoint.getId() + " is having trouble establishing the connection and will be marked as inactive");
                        }
                        ((Collection)this.inactiveEndpointIds).add(endpoint.getId());
                        changed = true;
                    }
                    Unit $i$a$-synchronized-EndpointConnectionStatusMonitor$monitorEndpointActivity$22 = Unit.INSTANCE;
                }
            }
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug(endpoint.getId() + " not ready for activity checks yet");
            }
            return;
        }
        Duration noActivityTime = Duration.between(lastActivity, now);
        active = noActivityTime.compareTo(EndpointConnectionStatusConfig.config.getMaxInactivityLimit()) <= 0;
        Set<String> set = this.inactiveEndpointIds;
        synchronized (set) {
            boolean wasActive;
            boolean bl = false;
            boolean bl2 = wasActive = !this.inactiveEndpointIds.contains(endpoint.getId());
            if (wasActive && !active) {
                this.logger.info(() -> EndpointConnectionStatusMonitor.monitorEndpointActivity$lambda-6$lambda-4(endpoint, noActivityTime));
                ((Collection)this.inactiveEndpointIds).add(endpoint.getId());
                endpointsDisconnected.inc();
                changed = true;
            } else if (!wasActive && active) {
                this.logger.info(() -> EndpointConnectionStatusMonitor.monitorEndpointActivity$lambda-6$lambda-5(endpoint));
                ((Collection)this.inactiveEndpointIds).remove(endpoint.getId());
                endpointsReconnected.inc();
                changed = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (changed) {
            String string = endpoint.getId();
            Intrinsics.checkNotNullExpressionValue(string, "endpoint.id");
            this.notifyStatusChange(string, active, null);
        }
    }

    private final void notifyStatusChange(String subjectEpId, boolean isConnected, String receiverEpId) {
        block1: {
            EndpointConnectionStatusMessage msg;
            block0: {
                msg = new EndpointConnectionStatusMessage(subjectEpId, isConnected);
                if (receiverEpId != null) break block0;
                this.conference.broadcastMessage(msg, true);
                break block1;
            }
            Endpoint endpoint = this.conference.getLocalEndpoint(receiverEpId);
            if (endpoint == null) break block1;
            Endpoint it = endpoint;
            boolean bl = false;
            this.conference.sendMessage(msg, CollectionsKt.listOf(it), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void endpointConnected(@NotNull String endpointId) {
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Set<String> set = this.inactiveEndpointIds;
        synchronized (set) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Endpoint it;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            List<Endpoint> list = this.conference.getLocalEndpoints();
            Intrinsics.checkNotNullExpressionValue(list, "conference.localEndpoints");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Endpoint)element$iv$iv;
                boolean bl2 = false;
                if (!(!it.getVisitor())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Endpoint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getId());
            }
            List localEndpointIds = (List)destination$iv$iv;
            Iterable $this$forEach$iv = this.inactiveEndpointIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String inactiveEpId = (String)element$iv;
                boolean bl4 = false;
                if (!localEndpointIds.contains(inactiveEpId)) continue;
                this.notifyStatusChange(inactiveEpId, false, endpointId);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmOverloads
    public EndpointConnectionStatusMonitor(@NotNull Conference conference, @NotNull ScheduledExecutorService executor, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(executor, "executor");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this(conference, executor, parentLogger, null, 8, null);
    }

    private static final String monitorEndpointActivity$lambda-6$lambda-4(Endpoint $endpoint, Duration $noActivityTime) {
        Intrinsics.checkNotNullParameter($endpoint, "$endpoint");
        return $endpoint.getId() + " is considered disconnected.  No activity for " + $noActivityTime;
    }

    private static final String monitorEndpointActivity$lambda-6$lambda-5(Endpoint $endpoint) {
        Intrinsics.checkNotNullParameter($endpoint, "$endpoint");
        return $endpoint.getId() + " has reconnected";
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/EndpointConnectionStatusMonitor$Companion;", "", "()V", "endpointsDisconnected", "Lorg/jitsi/metrics/CounterMetric;", "endpointsReconnected", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

