/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.extensions.PacketExtensionsKt;
import org.jitsi.rtp.rtcp.InvalidRtcpException;
import org.jitsi.rtp.rtcp.RtcpByePacket;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSdesPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.RtcpXrPacket;
import org.jitsi.rtp.rtcp.UnsupportedRtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010$\u001a\u00020\u0000H&R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010#\u00a8\u0006&"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpPacket;", "Lorg/jitsi/rtp/Packet;", "buffer", "", "offset", "", "length", "([BII)V", "hasPadding", "", "getHasPadding", "()Z", "lengthField", "getLengthField", "()I", "packetLength", "getPacketLength", "packetType", "getPacketType", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "reportCount", "getReportCount", "value", "", "senderSsrc", "getSenderSsrc", "()J", "setSenderSsrc", "(J)V", "version", "getVersion", "setVersion", "(I)V", "clone", "Companion", "rtp"})
public abstract class RtcpPacket
extends Packet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int packetLength;
    @NotNull
    private final String payloadVerification;

    public RtcpPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(buffer, offset, length);
        this.packetLength = (this.getLengthField() + 1) * 4;
        this.payloadVerification = "rtcp";
    }

    public final int getVersion() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.getVersion(this.buffer, this.offset);
    }

    public final void setVersion(int value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtcpHeader.Companion.setVersion(this.buffer, this.offset, value2);
    }

    public final boolean getHasPadding() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.hasPadding(this.buffer, this.offset);
    }

    public final int getReportCount() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.getReportCount(this.buffer, this.offset);
    }

    public final int getPacketType() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.getPacketType(this.buffer, this.offset);
    }

    public final int getLengthField() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.getLength(this.buffer, this.offset);
    }

    public final long getSenderSsrc() {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        return RtcpHeader.Companion.getSenderSsrc(this.buffer, this.offset);
    }

    public final void setSenderSsrc(long value2) {
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        RtcpHeader.Companion.setSenderSsrc(this.buffer, this.offset, value2);
    }

    public final int getPacketLength() {
        return this.packetLength;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        return this.payloadVerification;
    }

    @Override
    @NotNull
    public abstract RtcpPacket clone();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpPacket$Companion;", "", "()V", "parse", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "buf", "", "offset", "", "bytesRemaining", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RtcpPacket parse(@NotNull byte[] buf, int offset, int bytesRemaining) {
            RtcpPacket rtcpPacket;
            Intrinsics.checkNotNullParameter(buf, "buf");
            int packetType = RtcpHeader.Companion.getPacketType(buf, offset);
            int packetLengthBytes = (RtcpHeader.Companion.getLength(buf, offset) + 1) * 4;
            if (packetLengthBytes > bytesRemaining) {
                throw new InvalidRtcpException(buf, offset, "length " + packetLengthBytes + " > available " + bytesRemaining);
            }
            int n = packetType;
            if (n == 203) {
                rtcpPacket = new RtcpByePacket(buf, offset, packetLengthBytes);
            } else if (n == 201) {
                rtcpPacket = new RtcpRrPacket(buf, offset, packetLengthBytes);
            } else if (n == 200) {
                rtcpPacket = new RtcpSrPacket(buf, offset, packetLengthBytes);
            } else if (n == 202) {
                rtcpPacket = new RtcpSdesPacket(buf, offset, packetLengthBytes);
            } else if (RtcpFbPacket.Companion.getPACKET_TYPES().contains(n)) {
                rtcpPacket = RtcpFbPacket.Companion.parse(buf, offset, packetLengthBytes);
            } else if (n == 207) {
                rtcpPacket = new RtcpXrPacket(buf, offset, packetLengthBytes);
            } else {
                int n2 = packetType;
                IntRange intRange = PacketExtensionsKt.getRTCP_PACKET_TYPE_RANGE();
                int n3 = intRange.getFirst();
                if (!(n2 <= intRange.getLast() ? n3 <= n2 : false)) {
                    throw new InvalidRtcpException(buf, offset, "type " + packetType);
                }
                return new UnsupportedRtcpPacket(buf, offset, packetLengthBytes);
            }
            return rtcpPacket;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

